/*
 * Decompiled with CFR 0.152.
 */
package com.github._1c_syntax.bsl.languageserver.diagnostics;

import com.github._1c_syntax.bsl.languageserver.aop.MeasuresAspect;
import com.github._1c_syntax.bsl.languageserver.aop.SentryAspect;
import com.github._1c_syntax.bsl.languageserver.context.DocumentContext;
import com.github._1c_syntax.bsl.languageserver.diagnostics.AbstractVisitorDiagnostic;
import com.github._1c_syntax.bsl.languageserver.diagnostics.RedundantAccessToObjectDiagnostic$AjcClosure1;
import com.github._1c_syntax.bsl.languageserver.diagnostics.metadata.DiagnosticMetadata;
import com.github._1c_syntax.bsl.languageserver.diagnostics.metadata.DiagnosticParameter;
import com.github._1c_syntax.bsl.languageserver.diagnostics.metadata.DiagnosticScope;
import com.github._1c_syntax.bsl.languageserver.diagnostics.metadata.DiagnosticSeverity;
import com.github._1c_syntax.bsl.languageserver.diagnostics.metadata.DiagnosticTag;
import com.github._1c_syntax.bsl.languageserver.diagnostics.metadata.DiagnosticType;
import com.github._1c_syntax.bsl.mdo.support.ReturnValueReuse;
import com.github._1c_syntax.bsl.parser.BSLParser;
import com.github._1c_syntax.bsl.types.MDOType;
import com.github._1c_syntax.bsl.types.ModuleType;
import com.github._1c_syntax.mdclasses.mdo.MDCommonModule;
import com.github._1c_syntax.utils.CaseInsensitivePattern;
import java.util.ArrayList;
import java.util.List;
import java.util.regex.Pattern;
import org.antlr.v4.runtime.tree.ParseTree;
import org.antlr.v4.runtime.tree.TerminalNode;
import org.aspectj.lang.JoinPoint;
import org.aspectj.lang.Signature;
import org.aspectj.runtime.reflect.Factory;
import org.eclipse.lsp4j.Diagnostic;

@DiagnosticMetadata(type=DiagnosticType.CODE_SMELL, severity=DiagnosticSeverity.INFO, minutesToFix=1, modules={ModuleType.CommonModule, ModuleType.ObjectModule, ModuleType.ManagerModule, ModuleType.FormModule, ModuleType.RecordSetModule}, tags={DiagnosticTag.STANDARD, DiagnosticTag.CLUMSY}, scope=DiagnosticScope.BSL)
public class RedundantAccessToObjectDiagnostic
extends AbstractVisitorDiagnostic {
    private static final Pattern PATTERN;
    private static final Pattern PATTERN_WITH_DOT;
    private static final boolean CHECK_OBJECT_MODULE = true;
    private static final boolean CHECK_FORM_MODULE = true;
    private static final boolean CHECK_RECORD_SET_MODULE = true;
    private boolean needCheckName = false;
    private boolean skipLValue = false;
    private Pattern namePatternWithDot;
    @DiagnosticParameter(type=Boolean.class, defaultValue="true")
    private boolean checkObjectModule = true;
    @DiagnosticParameter(type=Boolean.class, defaultValue="true")
    private boolean checkFormModule = true;
    @DiagnosticParameter(type=Boolean.class, defaultValue="true")
    private boolean checkRecordSetModule = true;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_0;

    @Override
    public List<Diagnostic> getDiagnostics(DocumentContext documentContext) {
        DocumentContext documentContext2 = documentContext;
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_0, (Object)this, (Object)this, (Object)documentContext2);
        try {
            Object[] objectArray = new Object[]{this, documentContext2, joinPoint};
            RedundantAccessToObjectDiagnostic$AjcClosure1 redundantAccessToObjectDiagnostic$AjcClosure1 = new RedundantAccessToObjectDiagnostic$AjcClosure1(objectArray);
            return (List)MeasuresAspect.aspectOf().measureBSLDiagnostic(redundantAccessToObjectDiagnostic$AjcClosure1.linkClosureAndJoinPoint(69648));
        }
        catch (Throwable throwable) {
            SentryAspect.aspectOf().logThrowingBSLDiagnosticGetDiagnostics(throwable);
            throw throwable;
        }
    }

    public ParseTree visitCallStatement(BSLParser.CallStatementContext ctx) {
        if (ctx.globalMethodCall() != null && ctx.getStart() == ctx.globalMethodCall().getStart()) {
            return (ParseTree)super.visitCallStatement(ctx);
        }
        if (PATTERN_WITH_DOT.matcher(ctx.getText()).matches()) {
            this.diagnosticStorage.addDiagnostic(ctx.getStart());
        }
        if (this.needCheckName && this.namePatternWithDot.matcher(ctx.getText()).matches()) {
            this.diagnosticStorage.addDiagnostic(ctx.getStart());
        }
        return (ParseTree)super.visitCallStatement(ctx);
    }

    public ParseTree visitComplexIdentifier(BSLParser.ComplexIdentifierContext ctx) {
        TerminalNode identifier = ctx.IDENTIFIER();
        List modifiers = ctx.modifier();
        if (identifier == null || modifiers.isEmpty()) {
            return ctx;
        }
        if (PATTERN.matcher(identifier.getText()).matches() && modifiers.get(0) != null && ((BSLParser.ModifierContext)modifiers.get(0)).accessIndex() == null) {
            this.diagnosticStorage.addDiagnostic(ctx.getStart());
        }
        return ctx;
    }

    public ParseTree visitLValue(BSLParser.LValueContext ctx) {
        if (this.skipLValue) {
            return ctx;
        }
        TerminalNode identifier = ctx.IDENTIFIER();
        BSLParser.AcceptorContext acceptor = ctx.acceptor();
        if (identifier == null || acceptor == null) {
            return ctx;
        }
        if (PATTERN.matcher(identifier.getText()).matches() && RedundantAccessToObjectDiagnostic.notHasAccessIndex(acceptor) && RedundantAccessToObjectDiagnostic.hasAccessProperty(acceptor)) {
            this.diagnosticStorage.addDiagnostic(ctx.getStart());
        }
        return ctx;
    }

    private static String getManagerModuleName(MDOType objectType) {
        if (objectType == MDOType.CATALOG) {
            return "^(\u0421\u043f\u0440\u0430\u0432\u043e\u0447\u043d\u0438\u043a\u0438|Catalogs)\\.%s\\..*";
        }
        if (objectType == MDOType.DOCUMENT) {
            return "^(\u0414\u043e\u043a\u0443\u043c\u0435\u043d\u0442\u044b|Documents)\\.%s\\..*";
        }
        if (objectType == MDOType.ACCOUNTING_REGISTER) {
            return "^(\u0420\u0435\u0433\u0438\u0441\u0442\u0440\u044b\u0411\u0443\u0445\u0433\u0430\u043b\u0442\u0435\u0440\u0438\u0438|AccountingRegisters)\\.%s\\..*";
        }
        if (objectType == MDOType.ACCUMULATION_REGISTER) {
            return "^(\u0420\u0435\u0433\u0438\u0441\u0442\u0440\u044b\u041d\u0430\u043a\u043e\u043f\u043b\u0435\u043d\u0438\u044f|AccumulationRegisters)\\.%s\\..*";
        }
        if (objectType == MDOType.CALCULATION_REGISTER) {
            return "^(\u0420\u0435\u0433\u0438\u0441\u0442\u0440\u044b\u0420\u0430\u0441\u0447\u0435\u0442\u0430|CalculationRegisters)\\.%s\\..*";
        }
        if (objectType == MDOType.INFORMATION_REGISTER) {
            return "^(\u0420\u0435\u0433\u0438\u0441\u0442\u0440\u044b\u0421\u0432\u0435\u0434\u0435\u043d\u0438\u0439|InformationRegisters)\\.%s\\..*";
        }
        return "^%s\\..*";
    }

    private boolean skipModule(ModuleType typeModule) {
        return typeModule == ModuleType.ObjectModule && !this.checkObjectModule || typeModule == ModuleType.RecordSetModule && !this.checkRecordSetModule || typeModule == ModuleType.FormModule && !this.checkFormModule;
    }

    private static boolean notHasAccessIndex(BSLParser.AcceptorContext acceptor) {
        List modifiers = acceptor.modifier();
        return modifiers == null || modifiers.isEmpty() || modifiers.get(0) == null || ((BSLParser.ModifierContext)modifiers.get(0)).accessIndex() == null;
    }

    private static boolean hasAccessProperty(BSLParser.AcceptorContext acceptor) {
        return acceptor.accessProperty() != null;
    }

    static {
        RedundantAccessToObjectDiagnostic.ajc$preClinit();
        PATTERN = CaseInsensitivePattern.compile((String)"^\u042d\u0442\u043e\u0442\u041e\u0431\u044a\u0435\u043a\u0442|ThisObject");
        PATTERN_WITH_DOT = CaseInsensitivePattern.compile((String)"^(\u042d\u0442\u043e\u0442\u041e\u0431\u044a\u0435\u043a\u0442|ThisObject)\\..*");
    }

    static final /* synthetic */ List getDiagnostics_aroundBody0(RedundantAccessToObjectDiagnostic ajc$this, DocumentContext documentContext, JoinPoint joinPoint) {
        ModuleType typeModule = documentContext.getModuleType();
        if (typeModule == ModuleType.CommonModule || typeModule == ModuleType.ManagerModule) {
            documentContext.getMdObject().ifPresent(mdObjectBase -> {
                this.needCheckName = !(mdObjectBase instanceof MDCommonModule) || ((MDCommonModule)mdObjectBase).getReturnValuesReuse() == ReturnValueReuse.DONT_USE;
                this.skipLValue = true;
                this.namePatternWithDot = CaseInsensitivePattern.compile((String)String.format(RedundantAccessToObjectDiagnostic.getManagerModuleName(mdObjectBase.getMdoType()), mdObjectBase.getName()));
            });
        }
        if (ajc$this.skipModule(typeModule)) {
            return new ArrayList();
        }
        return super.getDiagnostics(documentContext);
    }

    private static /* synthetic */ void ajc$preClinit() {
        Factory factory = new Factory("RedundantAccessToObjectDiagnostic.java", RedundantAccessToObjectDiagnostic.class);
        ajc$tjp_0 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "getDiagnostics", "com.github._1c_syntax.bsl.languageserver.diagnostics.RedundantAccessToObjectDiagnostic", "com.github._1c_syntax.bsl.languageserver.context.DocumentContext", "documentContext", "", "java.util.List"), 95);
    }
}

