/*
 * Decompiled with CFR 0.152.
 */
package com.github._1c_syntax.bsl.languageserver.diagnostics;

import com.github._1c_syntax.bsl.languageserver.context.symbol.MethodSymbol;
import com.github._1c_syntax.bsl.languageserver.context.symbol.ParameterDefinition;
import com.github._1c_syntax.bsl.languageserver.context.symbol.VariableSymbol;
import com.github._1c_syntax.bsl.languageserver.diagnostics.AbstractDiagnostic;
import com.github._1c_syntax.bsl.languageserver.diagnostics.metadata.DiagnosticMetadata;
import com.github._1c_syntax.bsl.languageserver.diagnostics.metadata.DiagnosticSeverity;
import com.github._1c_syntax.bsl.languageserver.diagnostics.metadata.DiagnosticTag;
import com.github._1c_syntax.bsl.languageserver.diagnostics.metadata.DiagnosticType;
import com.github._1c_syntax.bsl.languageserver.references.ReferenceIndex;
import com.github._1c_syntax.bsl.languageserver.references.model.OccurrenceType;
import com.github._1c_syntax.bsl.languageserver.references.model.Reference;
import com.github._1c_syntax.bsl.languageserver.utils.RelatedInformation;
import com.github._1c_syntax.bsl.languageserver.utils.Trees;
import com.github._1c_syntax.bsl.parser.BSLParser;
import com.github._1c_syntax.bsl.parser.BSLParserRuleContext;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.beans.ConstructorProperties;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import lombok.Generated;
import org.antlr.v4.runtime.tree.RuleNode;
import org.antlr.v4.runtime.tree.TerminalNode;
import org.apache.commons.lang3.tuple.Pair;
import org.apache.commons.lang3.tuple.Triple;
import org.eclipse.lsp4j.DiagnosticRelatedInformation;
import org.eclipse.lsp4j.Position;
import org.eclipse.lsp4j.Range;
import org.eclipse.lsp4j.SymbolKind;

@DiagnosticMetadata(type=DiagnosticType.CODE_SMELL, severity=DiagnosticSeverity.MAJOR, minutesToFix=2, tags={DiagnosticTag.SUSPICIOUS})
public class RewriteMethodParameterDiagnostic
extends AbstractDiagnostic {
    private static final int COUNT_OF_PAIR_FOR_SELF_ASSIGN = 2;
    private final ReferenceIndex referenceIndex;

    @Override
    public void check() {
        this.documentContext.getSymbolTree().getMethods().stream().flatMap(RewriteMethodParameterDiagnostic::getParametersByValue).flatMap(pair -> RewriteMethodParameterDiagnostic.getVariableByParameter((MethodSymbol)pair.getLeft(), (ParameterDefinition)pair.getRight())).map(this::isOverwrited).filter(Optional::isPresent).map(Optional::get).forEach(variableSymbolReferenceListTriple -> this.fireIssue((VariableSymbol)variableSymbolReferenceListTriple.getLeft(), (Reference)variableSymbolReferenceListTriple.getMiddle(), (List)variableSymbolReferenceListTriple.getRight()));
    }

    private static Stream<Pair<MethodSymbol, ParameterDefinition>> getParametersByValue(MethodSymbol methodSymbol) {
        return methodSymbol.getParameters().stream().filter(ParameterDefinition::isByValue).map(parameterDefinition -> Pair.of((Object)methodSymbol, (Object)parameterDefinition));
    }

    private static Stream<VariableSymbol> getVariableByParameter(MethodSymbol method, ParameterDefinition parameterDefinition) {
        return method.getChildren().stream().filter(sourceDefinedSymbol -> sourceDefinedSymbol.getSymbolKind() == SymbolKind.Variable).filter(variable -> parameterDefinition.getRange().getStart().equals((Object)variable.getSelectionRange().getStart())).filter(VariableSymbol.class::isInstance).map(VariableSymbol.class::cast).findFirst().stream();
    }

    private Optional<Triple<VariableSymbol, Reference, List<Reference>>> isOverwrited(VariableSymbol variable) {
        List<Reference> references = this.getSortedReferencesByLocation(variable);
        return this.isOverwrited(references).map(defReference -> Triple.of((Object)variable, (Object)defReference, (Object)references));
    }

    private List<Reference> getSortedReferencesByLocation(VariableSymbol variable) {
        List<Reference> references = this.referenceIndex.getReferencesTo(variable);
        return references.stream().sorted((o1, o2) -> RewriteMethodParameterDiagnostic.compare(o1.getSelectionRange(), o2.getSelectionRange())).collect(Collectors.toList());
    }

    private static int compare(Range o1, Range o2) {
        return RewriteMethodParameterDiagnostic.compare(o1.getStart(), o2.getStart());
    }

    public static int compare(Position pos1, Position pos2) {
        if (pos1.getLine() < pos2.getLine()) {
            return -1;
        }
        if (pos1.getLine() > pos2.getLine()) {
            return 1;
        }
        return Integer.compare(pos1.getCharacter(), pos2.getCharacter());
    }

    private Optional<Reference> isOverwrited(List<Reference> references) {
        Reference firstDefIntoAssign;
        if (!references.isEmpty() && (firstDefIntoAssign = references.get(0)).getOccurrenceType() == OccurrenceType.DEFINITION) {
            if (references.size() == 1) {
                return Optional.of(firstDefIntoAssign);
            }
            Optional<RuleNode> refContextInsideDefAssign = this.getRefContextInsideDefAssign(firstDefIntoAssign, references.get(1));
            if (refContextInsideDefAssign.isEmpty()) {
                return Optional.of(firstDefIntoAssign);
            }
            boolean isSelfAssign = Boolean.TRUE.equals(refContextInsideDefAssign.map(RewriteMethodParameterDiagnostic::isVarNameOnlyIntoExpression).orElseThrow());
            if (isSelfAssign && references.size() > 2) {
                return this.isOverwrited(references.subList(2, references.size()));
            }
        }
        return Optional.empty();
    }

    private Optional<RuleNode> getRefContextInsideDefAssign(Reference defRef, Reference nextRef) {
        Optional<TerminalNode> defNode = Trees.findTerminalNodeContainsPosition((BSLParserRuleContext)this.documentContext.getAst(), defRef.getSelectionRange().getStart());
        Optional<BSLParser.AssignmentContext> assignment = defNode.map(TerminalNode::getParent).filter(BSLParser.LValueContext.class::isInstance).map(RuleNode::getParent).filter(BSLParser.AssignmentContext.class::isInstance).map(BSLParser.AssignmentContext.class::cast);
        return assignment.flatMap(assignContext -> Trees.findTerminalNodeContainsPosition((BSLParserRuleContext)assignContext, nextRef.getSelectionRange().getStart())).map(TerminalNode::getParent);
    }

    private static boolean isVarNameOnlyIntoExpression(RuleNode refContext) {
        return Optional.of(refContext).filter(BSLParser.ComplexIdentifierContext.class::isInstance).map(BSLParser.ComplexIdentifierContext.class::cast).filter(node -> node.getChildCount() == 1).map(RuleNode::getParent).filter(BSLParser.MemberContext.class::isInstance).map(RuleNode::getParent).filter(expression -> expression.getChildCount() == 1).filter(BSLParser.ExpressionContext.class::isInstance).isPresent();
    }

    private void fireIssue(VariableSymbol variable, Reference nodeForIssue, List<Reference> references) {
        List refsForIssue = references.stream().map(reference -> RelatedInformation.create(this.documentContext.getUri(), reference.getSelectionRange(), "+1")).collect(Collectors.toList());
        ArrayList<DiagnosticRelatedInformation> resultRefs = new ArrayList<DiagnosticRelatedInformation>();
        resultRefs.add(RelatedInformation.create(this.documentContext.getUri(), variable.getVariableNameRange(), "0"));
        resultRefs.addAll(refsForIssue);
        this.diagnosticStorage.addDiagnostic(nodeForIssue.getSelectionRange(), this.info.getMessage(variable.getName()), resultRefs);
    }

    @ConstructorProperties(value={"referenceIndex"})
    @SuppressFBWarnings(justification="generated code")
    @Generated
    public RewriteMethodParameterDiagnostic(ReferenceIndex referenceIndex) {
        this.referenceIndex = referenceIndex;
    }
}

