/*
 * Decompiled with CFR 0.152.
 */
package com.github._1c_syntax.bsl.languageserver.diagnostics;

import com.github._1c_syntax.bsl.languageserver.context.symbol.MethodSymbol;
import com.github._1c_syntax.bsl.languageserver.diagnostics.AbstractMetadataDiagnostic;
import com.github._1c_syntax.bsl.languageserver.diagnostics.metadata.DiagnosticMetadata;
import com.github._1c_syntax.bsl.languageserver.diagnostics.metadata.DiagnosticScope;
import com.github._1c_syntax.bsl.languageserver.diagnostics.metadata.DiagnosticSeverity;
import com.github._1c_syntax.bsl.languageserver.diagnostics.metadata.DiagnosticTag;
import com.github._1c_syntax.bsl.languageserver.diagnostics.metadata.DiagnosticType;
import com.github._1c_syntax.bsl.languageserver.references.ReferenceIndex;
import com.github._1c_syntax.bsl.mdo.support.Handler;
import com.github._1c_syntax.bsl.types.MDOType;
import com.github._1c_syntax.bsl.types.ModuleType;
import com.github._1c_syntax.mdclasses.mdo.AbstractMDObjectBase;
import com.github._1c_syntax.mdclasses.mdo.MDCommonModule;
import com.github._1c_syntax.mdclasses.mdo.MDScheduledJob;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;

@DiagnosticMetadata(type=DiagnosticType.ERROR, severity=DiagnosticSeverity.CRITICAL, minutesToFix=5, tags={DiagnosticTag.ERROR}, scope=DiagnosticScope.BSL)
public class ScheduledJobHandlerDiagnostic
extends AbstractMetadataDiagnostic {
    private static final String DIAGNOSTIC_MESSAGE = "diagnosticMessage";
    private static final String MISSING_MODULE_MESSAGE = "missingModule";
    private static final String NON_SERVER_MODULE_MESSAGE = "nonServerModule";
    private static final String NON_EXPORT_METHOD_MESSAGE = "nonExportMethod";
    private static final String METHOD_WITH_PARAMETERS_MESSAGE = "methodWithParameters";
    private static final String EMPTY_METHOD_MESSAGE = "emptyMethod";
    private static final String DOUBLE_MESSAGE = "doubleMessage";
    private final ReferenceIndex referenceIndex;
    private final Map<String, List<MDScheduledJob>> scheduledJobHandlers = new HashMap<String, List<MDScheduledJob>>();

    private static String getFullName(MDCommonModule mdCommonModule, String methodName) {
        return ScheduledJobHandlerDiagnostic.getFullName(mdCommonModule.getName(), methodName);
    }

    private static String getFullName(String commonModuleName, String methodName) {
        return commonModuleName.concat(".").concat(methodName);
    }

    public ScheduledJobHandlerDiagnostic(ReferenceIndex referenceIndex) {
        super(List.of(MDOType.SCHEDULED_JOB));
        this.referenceIndex = referenceIndex;
    }

    @Override
    protected void check() {
        super.check();
        this.checkHandlerDoubles();
    }

    private void checkHandlerDoubles() {
        this.scheduledJobHandlers.values().stream().filter(mdScheduledJobs -> mdScheduledJobs.size() > 1).map(mdScheduledJobs -> {
            mdScheduledJobs.sort(Comparator.comparing(AbstractMDObjectBase::getName));
            return mdScheduledJobs;
        }).forEach(this::fireIssueForDoubles);
        this.scheduledJobHandlers.clear();
    }

    private void fireIssueForDoubles(List<MDScheduledJob> mdScheduledJobs) {
        String scheduleJobNames = mdScheduledJobs.stream().map(AbstractMDObjectBase::getName).reduce((s, s2) -> s.concat(", ").concat((String)s2)).orElseThrow();
        Handler mdScheduledJob = mdScheduledJobs.get(0).getHandler();
        String methodPath = ScheduledJobHandlerDiagnostic.getFullName(mdScheduledJob.getModuleName(), mdScheduledJob.getMethodName());
        this.addDiagnostic(this.info.getResourceString(DOUBLE_MESSAGE, methodPath, scheduleJobNames));
    }

    @Override
    protected void checkMetadata(AbstractMDObjectBase mdo) {
        MDScheduledJob scheduleJob = (MDScheduledJob)mdo;
        Handler handler = scheduleJob.getHandler();
        if (handler.isEmpty()) {
            this.addDiagnostic(scheduleJob);
            return;
        }
        String moduleName = handler.getModuleName();
        Optional commonModuleOptional = this.documentContext.getServerContext().getConfiguration().getCommonModule(moduleName);
        if (commonModuleOptional.isEmpty()) {
            this.addDiagnostic(MISSING_MODULE_MESSAGE, scheduleJob, moduleName);
            return;
        }
        MDCommonModule mdCommonModule = (MDCommonModule)commonModuleOptional.orElseThrow();
        if (!mdCommonModule.isServer()) {
            this.addDiagnostic(NON_SERVER_MODULE_MESSAGE, scheduleJob, moduleName);
            return;
        }
        this.checkMethod(scheduleJob, mdCommonModule, handler.getMethodName());
    }

    private void checkMethod(MDScheduledJob scheduleJob, MDCommonModule mdCommonModule, String methodName) {
        String fullName = ScheduledJobHandlerDiagnostic.getFullName(mdCommonModule, methodName);
        this.scheduledJobHandlers.computeIfAbsent(fullName, k -> new ArrayList()).add(scheduleJob);
        this.documentContext.getServerContext().getDocument(mdCommonModule.getMdoReference().getMdoRef(), ModuleType.CommonModule).ifPresent(commonModuleContext -> {
            Optional<MethodSymbol> method = commonModuleContext.getSymbolTree().getMethods().stream().filter(methodSymbol -> methodSymbol.getName().equalsIgnoreCase(methodName)).findFirst();
            if (method.isEmpty()) {
                this.addDiagnostic(DIAGNOSTIC_MESSAGE, scheduleJob, fullName);
                return;
            }
            method.ifPresent(methodSymbol -> this.checkMethod(scheduleJob, fullName, (MethodSymbol)methodSymbol));
        });
    }

    private void checkMethod(MDScheduledJob scheduleJob, String fullName, MethodSymbol methodSymbol) {
        if (!methodSymbol.isExport()) {
            this.addDiagnostic(NON_EXPORT_METHOD_MESSAGE, scheduleJob, fullName);
        }
        if (scheduleJob.isPredefined() && !methodSymbol.getParameters().isEmpty()) {
            this.addDiagnostic(METHOD_WITH_PARAMETERS_MESSAGE, scheduleJob, fullName);
        }
        if (this.isEmptyMethodBody(methodSymbol)) {
            this.addDiagnostic(EMPTY_METHOD_MESSAGE, scheduleJob, fullName);
        }
    }

    private boolean isEmptyMethodBody(MethodSymbol methodSymbol) {
        if (!methodSymbol.getChildren().isEmpty()) {
            return false;
        }
        return this.referenceIndex.getReferencesFrom(methodSymbol).isEmpty();
    }

    private void addDiagnostic(String messageString, MDScheduledJob scheduleJob, String text) {
        this.addDiagnostic(this.info.getResourceString(messageString, text, scheduleJob.getName()));
    }

    private void addDiagnostic(MDScheduledJob scheduleJob) {
        this.addDiagnostic(this.info.getMessage("", scheduleJob.getName()));
    }
}

