/*
 * Decompiled with CFR 0.152.
 */
package com.github._1c_syntax.bsl.languageserver.diagnostics;

import com.github._1c_syntax.bsl.languageserver.diagnostics.AbstractVisitorDiagnostic;
import com.github._1c_syntax.bsl.languageserver.diagnostics.metadata.DiagnosticMetadata;
import com.github._1c_syntax.bsl.languageserver.diagnostics.metadata.DiagnosticSeverity;
import com.github._1c_syntax.bsl.languageserver.diagnostics.metadata.DiagnosticTag;
import com.github._1c_syntax.bsl.languageserver.diagnostics.metadata.DiagnosticType;
import com.github._1c_syntax.bsl.parser.BSLParser;
import com.github._1c_syntax.bsl.parser.BSLParserRuleContext;
import com.github._1c_syntax.utils.CaseInsensitivePattern;
import java.util.List;
import java.util.regex.Pattern;
import org.antlr.v4.runtime.tree.ParseTree;

@DiagnosticMetadata(type=DiagnosticType.ERROR, severity=DiagnosticSeverity.MAJOR, minutesToFix=10, tags={DiagnosticTag.STANDARD, DiagnosticTag.UNPREDICTABLE, DiagnosticTag.PERFORMANCE})
public class SelfInsertionDiagnostic
extends AbstractVisitorDiagnostic {
    private static final Pattern deletePattern = CaseInsensitivePattern.compile((String)"(\u0432\u0441\u0442\u0430\u0432\u0438\u0442\u044c|\u0434\u043e\u0431\u0430\u0432\u0438\u0442\u044c|insert|add)");

    public ParseTree visitCallStatement(BSLParser.CallStatementContext ctx) {
        if (ctx.globalMethodCall() != null) {
            return ctx;
        }
        String identifier = ctx.IDENTIFIER().getText().trim();
        BSLParser.MethodCallContext methodCall = ctx.accessCall().methodCall();
        if (deletePattern.matcher(methodCall.methodName().getText()).matches()) {
            List callParams = methodCall.doCall().callParamList().callParam();
            for (BSLParser.CallParamContext param : callParams) {
                if (!param.getText().trim().equals(identifier)) continue;
                this.diagnosticStorage.addDiagnostic((BSLParserRuleContext)ctx);
            }
        }
        return ctx;
    }
}

