/*
 * Decompiled with CFR 0.152.
 */
package com.github._1c_syntax.bsl.languageserver.diagnostics;

import com.github._1c_syntax.bsl.languageserver.diagnostics.AbstractVisitorDiagnostic;
import com.github._1c_syntax.bsl.languageserver.diagnostics.metadata.DiagnosticMetadata;
import com.github._1c_syntax.bsl.languageserver.diagnostics.metadata.DiagnosticSeverity;
import com.github._1c_syntax.bsl.languageserver.diagnostics.metadata.DiagnosticTag;
import com.github._1c_syntax.bsl.languageserver.diagnostics.metadata.DiagnosticType;
import com.github._1c_syntax.bsl.languageserver.utils.Trees;
import com.github._1c_syntax.bsl.parser.BSLParser;
import com.github._1c_syntax.utils.CaseInsensitivePattern;
import java.util.function.Predicate;
import java.util.regex.Pattern;
import org.antlr.v4.runtime.tree.ParseTree;

@DiagnosticMetadata(type=DiagnosticType.CODE_SMELL, severity=DiagnosticSeverity.MAJOR, minutesToFix=2, tags={DiagnosticTag.STANDARD})
public class TryNumberDiagnostic
extends AbstractVisitorDiagnostic {
    private static final Pattern NUMBER_PATTERN = CaseInsensitivePattern.compile((String)"\u0447\u0438\u0441\u043b\u043e|number");
    private static final Predicate<BSLParser.GlobalMethodCallContext> MATCH_METHOD_CALL_CAST_TO_NUMBER = e -> NUMBER_PATTERN.matcher(e.methodName().getText()).matches();

    public ParseTree visitTryCodeBlock(BSLParser.TryCodeBlockContext ctx) {
        Trees.findAllRuleNodes((ParseTree)ctx, 93).stream().filter(BSLParser.GlobalMethodCallContext.class::isInstance).map(BSLParser.GlobalMethodCallContext.class::cast).filter(MATCH_METHOD_CALL_CAST_TO_NUMBER).forEach(this.diagnosticStorage::addDiagnostic);
        return ctx;
    }
}

