/*
 * Decompiled with CFR 0.152.
 */
package com.github._1c_syntax.bsl.languageserver.diagnostics;

import com.github._1c_syntax.bsl.languageserver.diagnostics.AbstractVisitorDiagnostic;
import com.github._1c_syntax.bsl.languageserver.diagnostics.metadata.DiagnosticMetadata;
import com.github._1c_syntax.bsl.languageserver.diagnostics.metadata.DiagnosticSeverity;
import com.github._1c_syntax.bsl.languageserver.diagnostics.metadata.DiagnosticTag;
import com.github._1c_syntax.bsl.languageserver.diagnostics.metadata.DiagnosticType;
import com.github._1c_syntax.bsl.languageserver.utils.Trees;
import com.github._1c_syntax.bsl.parser.BSLParser;
import java.util.Optional;
import org.antlr.v4.runtime.Token;
import org.antlr.v4.runtime.tree.ParseTree;

@DiagnosticMetadata(type=DiagnosticType.ERROR, severity=DiagnosticSeverity.BLOCKER, minutesToFix=1, tags={DiagnosticTag.SUSPICIOUS, DiagnosticTag.BRAINOVERLOAD})
public class UnaryPlusInConcatenationDiagnostic
extends AbstractVisitorDiagnostic {
    public ParseTree visitMember(BSLParser.MemberContext ctx) {
        if (ctx.constValue() != null && ctx.constValue().numeric() != null) {
            return (ParseTree)super.visitMember(ctx);
        }
        BSLParser.UnaryModifierContext unaryModifier = ctx.unaryModifier();
        if (unaryModifier == null || unaryModifier.PLUS() == null) {
            return (ParseTree)super.visitMember(ctx);
        }
        int tokenIndex = unaryModifier.getStart().getTokenIndex();
        if (tokenIndex == 0) {
            return (ParseTree)super.visitMember(ctx);
        }
        Optional<Token> previousToken = Trees.getPreviousTokenFromDefaultChannel(this.documentContext.getTokens(), tokenIndex);
        previousToken.filter(token -> "+".equals(token.getText())).ifPresent(token -> this.diagnosticStorage.addDiagnostic(unaryModifier.getStart()));
        return (ParseTree)super.visitMember(ctx);
    }
}

