/*
 * Decompiled with CFR 0.152.
 */
package com.github._1c_syntax.bsl.languageserver.diagnostics;

import com.github._1c_syntax.bsl.languageserver.context.symbol.MethodSymbol;
import com.github._1c_syntax.bsl.languageserver.context.symbol.annotations.Annotation;
import com.github._1c_syntax.bsl.languageserver.context.symbol.annotations.AnnotationKind;
import com.github._1c_syntax.bsl.languageserver.diagnostics.AbstractVisitorDiagnostic;
import com.github._1c_syntax.bsl.languageserver.diagnostics.metadata.DiagnosticMetadata;
import com.github._1c_syntax.bsl.languageserver.diagnostics.metadata.DiagnosticParameter;
import com.github._1c_syntax.bsl.languageserver.diagnostics.metadata.DiagnosticSeverity;
import com.github._1c_syntax.bsl.languageserver.diagnostics.metadata.DiagnosticTag;
import com.github._1c_syntax.bsl.languageserver.diagnostics.metadata.DiagnosticType;
import com.github._1c_syntax.bsl.languageserver.utils.DiagnosticHelper;
import com.github._1c_syntax.bsl.parser.BSLParser;
import com.github._1c_syntax.bsl.types.ModuleType;
import com.github._1c_syntax.utils.CaseInsensitivePattern;
import java.util.EnumSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import org.antlr.v4.runtime.tree.ParseTree;
import org.antlr.v4.runtime.tree.Trees;

@DiagnosticMetadata(type=DiagnosticType.CODE_SMELL, severity=DiagnosticSeverity.MAJOR, modules={ModuleType.CommonModule}, minutesToFix=1, tags={DiagnosticTag.STANDARD, DiagnosticTag.SUSPICIOUS, DiagnosticTag.UNUSED})
public class UnusedLocalMethodDiagnostic
extends AbstractVisitorDiagnostic {
    private static final Pattern HANDLER_PATTERN = CaseInsensitivePattern.compile((String)"(\u041f\u0440\u0438\u0421\u043e\u0437\u0434\u0430\u043d\u0438\u0438\u041e\u0431\u044a\u0435\u043a\u0442\u0430|OnObjectCreate)");
    private static final String ATTACHABLE_METHOD_PREFIXES = "\u043f\u043e\u0434\u043a\u043b\u044e\u0447\u0430\u0435\u043c\u044b\u0439_,attachable_";
    private static final Set<AnnotationKind> EXTENSION_ANNOTATIONS = EnumSet.of(AnnotationKind.AFTER, AnnotationKind.AROUND, AnnotationKind.BEFORE, AnnotationKind.CHANGEANDVALIDATE);
    @DiagnosticParameter(type=String.class, defaultValue="\u043f\u043e\u0434\u043a\u043b\u044e\u0447\u0430\u0435\u043c\u044b\u0439_,attachable_")
    private Pattern attachableMethodPrefixes = DiagnosticHelper.createPatternFromString("\u043f\u043e\u0434\u043a\u043b\u044e\u0447\u0430\u0435\u043c\u044b\u0439_,attachable_");

    @Override
    public void configure(Map<String, Object> configuration) {
        this.attachableMethodPrefixes = DiagnosticHelper.createPatternFromString((String)configuration.getOrDefault("attachableMethodPrefixes", ATTACHABLE_METHOD_PREFIXES));
    }

    private boolean isAttachable(MethodSymbol methodSymbol) {
        return this.attachableMethodPrefixes.matcher(methodSymbol.getName()).matches();
    }

    private static boolean isHandler(MethodSymbol methodSymbol) {
        return HANDLER_PATTERN.matcher(methodSymbol.getName()).matches();
    }

    private static boolean isOverride(MethodSymbol method) {
        return method.getAnnotations().stream().map(Annotation::getKind).anyMatch(EXTENSION_ANNOTATIONS::contains);
    }

    public ParseTree visitFile(BSLParser.FileContext ctx) {
        List collect = Trees.findAllRuleNodes((ParseTree)ctx, (int)93).stream().map(parseTree -> ((BSLParser.GlobalMethodCallContext)parseTree).methodName().getText().toLowerCase(Locale.ENGLISH)).collect(Collectors.toList());
        this.documentContext.getSymbolTree().getMethods().stream().filter(method -> !method.isExport()).filter(method -> !UnusedLocalMethodDiagnostic.isOverride(method)).filter(method -> !this.isAttachable((MethodSymbol)method)).filter(method -> !UnusedLocalMethodDiagnostic.isHandler(method)).filter(method -> !collect.contains(method.getName().toLowerCase(Locale.ENGLISH))).forEach(method -> this.diagnosticStorage.addDiagnostic(method.getSubNameRange(), this.info.getMessage(method.getName())));
        return ctx;
    }
}

