/*
 * Decompiled with CFR 0.152.
 */
package com.github._1c_syntax.bsl.languageserver.diagnostics;

import com.github._1c_syntax.bsl.languageserver.context.symbol.MethodSymbol;
import com.github._1c_syntax.bsl.languageserver.context.symbol.annotations.CompilerDirectiveKind;
import com.github._1c_syntax.bsl.languageserver.diagnostics.AbstractVisitorDiagnostic;
import com.github._1c_syntax.bsl.languageserver.diagnostics.metadata.DiagnosticCompatibilityMode;
import com.github._1c_syntax.bsl.languageserver.diagnostics.metadata.DiagnosticMetadata;
import com.github._1c_syntax.bsl.languageserver.diagnostics.metadata.DiagnosticScope;
import com.github._1c_syntax.bsl.languageserver.diagnostics.metadata.DiagnosticSeverity;
import com.github._1c_syntax.bsl.languageserver.diagnostics.metadata.DiagnosticTag;
import com.github._1c_syntax.bsl.languageserver.diagnostics.metadata.DiagnosticType;
import com.github._1c_syntax.bsl.mdo.support.UseMode;
import com.github._1c_syntax.bsl.parser.BSLParser;
import com.github._1c_syntax.bsl.parser.BSLParserRuleContext;
import com.github._1c_syntax.mdclasses.Configuration;
import com.github._1c_syntax.utils.CaseInsensitivePattern;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.Locale;
import java.util.Optional;
import java.util.Set;
import java.util.regex.Pattern;
import org.antlr.v4.runtime.tree.ParseTree;

@DiagnosticMetadata(type=DiagnosticType.CODE_SMELL, severity=DiagnosticSeverity.MAJOR, scope=DiagnosticScope.BSL, minutesToFix=15, tags={DiagnosticTag.STANDARD}, compatibilityMode=DiagnosticCompatibilityMode.COMPATIBILITY_MODE_8_3_3)
public class UsingSynchronousCallsDiagnostic
extends AbstractVisitorDiagnostic {
    private static final Pattern MODALITY_METHODS = CaseInsensitivePattern.compile((String)"(\u0412\u041e\u041f\u0420\u041e\u0421|DOQUERYBOX|\u041e\u0422\u041a\u0420\u042b\u0422\u042c\u0424\u041e\u0420\u041c\u0423\u041c\u041e\u0414\u0410\u041b\u042c\u041d\u041e|OPENFORMMODAL|\u041e\u0422\u041a\u0420\u042b\u0422\u042c\u0417\u041d\u0410\u0427\u0415\u041d\u0418\u0415|OPENVALUE|\u041f\u0420\u0415\u0414\u0423\u041f\u0420\u0415\u0416\u0414\u0415\u041d\u0418\u0415|DOMESSAGEBOX|\u0412\u0412\u0415\u0421\u0422\u0418\u0414\u0410\u0422\u0423|INPUTDATE|\u0412\u0412\u0415\u0421\u0422\u0418\u0417\u041d\u0410\u0427\u0415\u041d\u0418\u0415|INPUTVALUE|\u0412\u0412\u0415\u0421\u0422\u0418\u0421\u0422\u0420\u041e\u041a\u0423|INPUTSTRING|\u0412\u0412\u0415\u0421\u0422\u0418\u0427\u0418\u0421\u041b\u041e|INPUTNUMBER|\u0423\u0421\u0422\u0410\u041d\u041e\u0412\u0418\u0422\u042c\u0412\u041d\u0415\u0428\u041d\u042e\u042e\u041a\u041e\u041c\u041f\u041e\u041d\u0415\u041d\u0422\u0423|INSTALLADDIN|\u0423\u0421\u0422\u0410\u041d\u041e\u0412\u0418\u0422\u042c\u0420\u0410\u0421\u0428\u0418\u0420\u0415\u041d\u0418\u0415\u0420\u0410\u0411\u041e\u0422\u042b\u0421\u0424\u0410\u0419\u041b\u0410\u041c\u0418|INSTALLFILESYSTEMEXTENSION|\u0423\u0421\u0422\u0410\u041d\u041e\u0412\u0418\u0422\u042c\u0420\u0410\u0421\u0428\u0418\u0420\u0415\u041d\u0418\u0415\u0420\u0410\u0411\u041e\u0422\u042b\u0421\u041a\u0420\u0418\u041f\u0422\u041e\u0413\u0420\u0410\u0424\u0418\u0415\u0419|INSTALLCRYPTOEXTENSION|\u041f\u041e\u0414\u041a\u041b\u042e\u0427\u0418\u0422\u042c\u0420\u0410\u0421\u0428\u0418\u0420\u0415\u041d\u0418\u0415\u0420\u0410\u0411\u041e\u0422\u042b\u0421\u041a\u0420\u0418\u041f\u0422\u041e\u0413\u0420\u0410\u0424\u0418\u0415\u0419|ATTACHCRYPTOEXTENSION|\u041f\u041e\u0414\u041a\u041b\u042e\u0427\u0418\u0422\u042c\u0420\u0410\u0421\u0428\u0418\u0420\u0415\u041d\u0418\u0415\u0420\u0410\u0411\u041e\u0422\u042b\u0421\u0424\u0410\u0419\u041b\u0410\u041c\u0418|ATTACHFILESYSTEMEXTENSION|\u041f\u041e\u041c\u0415\u0421\u0422\u0418\u0422\u042c\u0424\u0410\u0419\u041b|PUTFILE|\u041a\u041e\u041f\u0418\u0420\u041e\u0412\u0410\u0422\u042c\u0424\u0410\u0419\u041b|FILECOPY|\u041f\u0415\u0420\u0415\u041c\u0415\u0421\u0422\u0418\u0422\u042c\u0424\u0410\u0419\u041b|MOVEFILE|\u041d\u0410\u0419\u0422\u0418\u0424\u0410\u0419\u041b\u042b|FINDFILES|\u0423\u0414\u0410\u041b\u0418\u0422\u042c\u0424\u0410\u0419\u041b\u042b|DELETEFILES|\u0421\u041e\u0417\u0414\u0410\u0422\u042c\u041a\u0410\u0422\u0410\u041b\u041e\u0413|CREATEDIRECTORY|\u041a\u0410\u0422\u0410\u041b\u041e\u0413\u0412\u0420\u0415\u041c\u0415\u041d\u041d\u042b\u0425\u0424\u0410\u0419\u041b\u041e\u0412|TEMPFILESDIR|\u041a\u0410\u0422\u0410\u041b\u041e\u0413\u0414\u041e\u041a\u0423\u041c\u0415\u041d\u0422\u041e\u0412|DOCUMENTSDIR|\u0420\u0410\u0411\u041e\u0427\u0418\u0419\u041a\u0410\u0422\u0410\u041b\u041e\u0413\u0414\u0410\u041d\u041d\u042b\u0425\u041f\u041e\u041b\u042c\u0417\u041e\u0412\u0410\u0422\u0415\u041b\u042f|USERDATAWORKDIR|\u041f\u041e\u041b\u0423\u0427\u0418\u0422\u042c\u0424\u0410\u0419\u041b\u042b|GETFILES|\u041f\u041e\u041c\u0415\u0421\u0422\u0418\u0422\u042c\u0424\u0410\u0419\u041b\u042b|PUTFILES|\u0417\u0410\u041f\u0420\u041e\u0421\u0418\u0422\u042c\u0420\u0410\u0417\u0420\u0415\u0428\u0415\u041d\u0418\u0415\u041f\u041e\u041b\u042c\u0417\u041e\u0412\u0410\u0422\u0415\u041b\u042f|REQUESTUSERPERMISSION|\u0417\u0410\u041f\u0423\u0421\u0422\u0418\u0422\u042c\u041f\u0420\u0418\u041b\u041e\u0416\u0415\u041d\u0418\u0415|RUNAPP)");
    private static final Set<CompilerDirectiveKind> serverCompilerDirectives = EnumSet.of(CompilerDirectiveKind.AT_SERVER, CompilerDirectiveKind.AT_SERVER_NO_CONTEXT);
    private final HashMap<String, String> pairMethods = new HashMap();

    public UsingSynchronousCallsDiagnostic() {
        this.pairMethods.put("\u0412\u041e\u041f\u0420\u041e\u0421", "\u041f\u043e\u043a\u0430\u0437\u0430\u0442\u044c\u0412\u043e\u043f\u0440\u043e\u0441");
        this.pairMethods.put("DOQUERYBOX", "ShowQueryBox");
        this.pairMethods.put("\u041e\u0422\u041a\u0420\u042b\u0422\u042c\u0424\u041e\u0420\u041c\u0423\u041c\u041e\u0414\u0410\u041b\u042c\u041d\u041e", "\u041e\u0442\u043a\u0440\u044b\u0442\u044c\u0424\u043e\u0440\u043c\u0443");
        this.pairMethods.put("OPENFORMMODAL", "OpenForm");
        this.pairMethods.put("\u041e\u0422\u041a\u0420\u042b\u0422\u042c\u0417\u041d\u0410\u0427\u0415\u041d\u0418\u0415", "\u041f\u043e\u043a\u0430\u0437\u0430\u0442\u044c\u0417\u043d\u0430\u0447\u0435\u043d\u0438\u0435");
        this.pairMethods.put("OPENVALUE", "ShowValue");
        this.pairMethods.put("\u041f\u0420\u0415\u0414\u0423\u041f\u0420\u0415\u0416\u0414\u0415\u041d\u0418\u0415", "\u041f\u043e\u043a\u0430\u0437\u0430\u0442\u044c\u041f\u0440\u0435\u0434\u0443\u043f\u0440\u0435\u0436\u0434\u0435\u043d\u0438\u0435");
        this.pairMethods.put("DOMESSAGEBOX", "ShowMessageBox");
        this.pairMethods.put("\u0412\u0412\u0415\u0421\u0422\u0418\u0414\u0410\u0422\u0423", "\u041f\u043e\u043a\u0430\u0437\u0430\u0442\u044c\u0412\u0432\u043e\u0434\u0414\u0430\u0442\u044b");
        this.pairMethods.put("INPUTDATE", "ShowInputDate");
        this.pairMethods.put("\u0412\u0412\u0415\u0421\u0422\u0418\u0417\u041d\u0410\u0427\u0415\u041d\u0418\u0415", "\u041f\u043e\u043a\u0430\u0437\u0430\u0442\u044c\u0412\u0432\u043e\u0434\u0417\u043d\u0430\u0447\u0435\u043d\u0438\u044f");
        this.pairMethods.put("INPUTVALUE", "ShowInputValue");
        this.pairMethods.put("\u0412\u0412\u0415\u0421\u0422\u0418\u0421\u0422\u0420\u041e\u041a\u0423", "\u041f\u043e\u043a\u0430\u0437\u0430\u0442\u044c\u0412\u0432\u043e\u0434\u0421\u0442\u0440\u043e\u043a\u0438");
        this.pairMethods.put("INPUTSTRING", "ShowInputString");
        this.pairMethods.put("\u0412\u0412\u0415\u0421\u0422\u0418\u0427\u0418\u0421\u041b\u041e", "\u041f\u043e\u043a\u0430\u0437\u0430\u0442\u044c\u0412\u0432\u043e\u0434\u0427\u0438\u0441\u043b\u0430");
        this.pairMethods.put("INPUTNUMBER", "ShowInputNumber");
        this.pairMethods.put("\u0423\u0421\u0422\u0410\u041d\u041e\u0412\u0418\u0422\u042c\u0412\u041d\u0415\u0428\u041d\u042e\u042e\u041a\u041e\u041c\u041f\u041e\u041d\u0415\u041d\u0422\u0423", "\u041d\u0430\u0447\u0430\u0442\u044c\u0423\u0441\u0442\u0430\u043d\u043e\u0432\u043a\u0443\u0412\u043d\u0435\u0448\u043d\u0435\u0439\u041a\u043e\u043c\u043f\u043e\u043d\u0435\u043d\u0442\u044b");
        this.pairMethods.put("INSTALLADDIN", "BeginInstallAddIn");
        this.pairMethods.put("\u0423\u0421\u0422\u0410\u041d\u041e\u0412\u0418\u0422\u042c\u0420\u0410\u0421\u0428\u0418\u0420\u0415\u041d\u0418\u0415\u0420\u0410\u0411\u041e\u0422\u042b\u0421\u0424\u0410\u0419\u041b\u0410\u041c\u0418", "\u041d\u0430\u0447\u0430\u0442\u044c\u0423\u0441\u0442\u0430\u043d\u043e\u0432\u043a\u0443\u0420\u0430\u0441\u0448\u0438\u0440\u0435\u043d\u0438\u044f\u0420\u0430\u0431\u043e\u0442\u044b\u0421\u0424\u0430\u0439\u043b\u0430\u043c\u0438");
        this.pairMethods.put("INSTALLFILESYSTEMEXTENSION", "BeginInstallFileSystemExtension");
        this.pairMethods.put("\u0423\u0421\u0422\u0410\u041d\u041e\u0412\u0418\u0422\u042c\u0420\u0410\u0421\u0428\u0418\u0420\u0415\u041d\u0418\u0415\u0420\u0410\u0411\u041e\u0422\u042b\u0421\u041a\u0420\u0418\u041f\u0422\u041e\u0413\u0420\u0410\u0424\u0418\u0415\u0419", "\u041d\u0430\u0447\u0430\u0442\u044c\u0423\u0441\u0442\u0430\u043d\u043e\u0432\u043a\u0443\u0420\u0430\u0441\u0448\u0438\u0440\u0435\u043d\u0438\u044f\u0420\u0430\u0431\u043e\u0442\u044b\u0421\u041a\u0440\u0438\u043f\u0442\u043e\u0433\u0440\u0430\u0444\u0438\u0435\u0439");
        this.pairMethods.put("INSTALLCRYPTOEXTENSION", "BeginInstallCryptoExtension");
        this.pairMethods.put("\u041f\u041e\u0414\u041a\u041b\u042e\u0427\u0418\u0422\u042c\u0420\u0410\u0421\u0428\u0418\u0420\u0415\u041d\u0418\u0415\u0420\u0410\u0411\u041e\u0422\u042b\u0421\u041a\u0420\u0418\u041f\u0422\u041e\u0413\u0420\u0410\u0424\u0418\u0415\u0419", "\u041d\u0430\u0447\u0430\u0442\u044c\u041f\u043e\u0434\u043a\u043b\u044e\u0447\u0435\u043d\u0438\u0435\u0420\u0430\u0441\u0448\u0438\u0440\u0435\u043d\u0438\u044f\u0420\u0430\u0431\u043e\u0442\u044b\u0421\u041a\u0440\u0438\u043f\u0442\u043e\u0433\u0440\u0430\u0444\u0438\u0435\u0439");
        this.pairMethods.put("ATTACHCRYPTOEXTENSION", "BeginAttachingCryptoExtension");
        this.pairMethods.put("\u041f\u041e\u0414\u041a\u041b\u042e\u0427\u0418\u0422\u042c\u0420\u0410\u0421\u0428\u0418\u0420\u0415\u041d\u0418\u0415\u0420\u0410\u0411\u041e\u0422\u042b\u0421\u0424\u0410\u0419\u041b\u0410\u041c\u0418", "\u041d\u0430\u0447\u0430\u0442\u044c\u041f\u043e\u0434\u043a\u043b\u044e\u0447\u0435\u043d\u0438\u0435\u0420\u0430\u0441\u0448\u0438\u0440\u0435\u043d\u0438\u044f\u0420\u0430\u0431\u043e\u0442\u044b\u0421\u0424\u0430\u0439\u043b\u0430\u043c\u0438");
        this.pairMethods.put("ATTACHFILESYSTEMEXTENSION", "BeginAttachingFileSystemExtension");
        this.pairMethods.put("\u041f\u041e\u041c\u0415\u0421\u0422\u0418\u0422\u042c\u0424\u0410\u0419\u041b", "\u041d\u0430\u0447\u0430\u0442\u044c\u041f\u043e\u043c\u0435\u0449\u0435\u043d\u0438\u0435\u0424\u0430\u0439\u043b\u0430");
        this.pairMethods.put("PUTFILE", "BeginPutFile");
        this.pairMethods.put("\u041a\u041e\u041f\u0418\u0420\u041e\u0412\u0410\u0422\u042c\u0424\u0410\u0419\u041b", "\u041d\u0430\u0447\u0430\u0442\u044c\u041a\u043e\u043f\u0438\u0440\u043e\u0432\u0430\u043d\u0438\u0435\u0424\u0430\u0439\u043b\u0430");
        this.pairMethods.put("FILECOPY", "BeginCopyingFile");
        this.pairMethods.put("\u041f\u0415\u0420\u0415\u041c\u0415\u0421\u0422\u0418\u0422\u042c\u0424\u0410\u0419\u041b", "\u041d\u0430\u0447\u0430\u0442\u044c\u041f\u0435\u0440\u0435\u043c\u0435\u0449\u0435\u043d\u0438\u0435\u0424\u0430\u0439\u043b\u0430");
        this.pairMethods.put("MOVEFILE", "BeginMovingFile");
        this.pairMethods.put("\u041d\u0410\u0419\u0422\u0418\u0424\u0410\u0419\u041b\u042b", "\u041d\u0430\u0447\u0430\u0442\u044c\u041f\u043e\u0438\u0441\u043a\u0424\u0430\u0439\u043b\u043e\u0432");
        this.pairMethods.put("FINDFILES", "BeginFindingFiles");
        this.pairMethods.put("\u0423\u0414\u0410\u041b\u0418\u0422\u042c\u0424\u0410\u0419\u041b\u042b", "\u041d\u0430\u0447\u0430\u0442\u044c\u0423\u0434\u0430\u043b\u0435\u043d\u0438\u0435\u0424\u0430\u0439\u043b\u043e\u0432");
        this.pairMethods.put("DELETEFILES", "BeginDeletingFiles");
        this.pairMethods.put("\u0421\u041e\u0417\u0414\u0410\u0422\u042c\u041a\u0410\u0422\u0410\u041b\u041e\u0413", "\u041d\u0430\u0447\u0430\u0442\u044c\u0421\u043e\u0437\u0434\u0430\u043d\u0438\u0435\u041a\u0430\u0442\u0430\u043b\u043e\u0433\u0430");
        this.pairMethods.put("CREATEDIRECTORY", "BeginCreatingDirectory");
        this.pairMethods.put("\u041a\u0410\u0422\u0410\u041b\u041e\u0413\u0412\u0420\u0415\u041c\u0415\u041d\u041d\u042b\u0425\u0424\u0410\u0419\u041b\u041e\u0412", "\u041d\u0430\u0447\u0430\u0442\u044c\u041f\u043e\u043b\u0443\u0447\u0435\u043d\u0438\u0435\u041a\u0430\u0442\u0430\u043b\u043e\u0433\u0430\u0412\u0440\u0435\u043c\u0435\u043d\u043d\u044b\u0445\u0424\u0430\u0439\u043b\u043e\u0432");
        this.pairMethods.put("TEMPFILESDIR", "BeginGettingTempFilesDir");
        this.pairMethods.put("\u041a\u0410\u0422\u0410\u041b\u041e\u0413\u0414\u041e\u041a\u0423\u041c\u0415\u041d\u0422\u041e\u0412", "\u041d\u0430\u0447\u0430\u0442\u044c\u041f\u043e\u043b\u0443\u0447\u0435\u043d\u0438\u0435\u041a\u0430\u0442\u0430\u043b\u043e\u0433\u0430\u0414\u043e\u043a\u0443\u043c\u0435\u043d\u0442\u043e\u0432");
        this.pairMethods.put("DOCUMENTSDIR", "BeginGettingDocumentsDir");
        this.pairMethods.put("\u0420\u0410\u0411\u041e\u0427\u0418\u0419\u041a\u0410\u0422\u0410\u041b\u041e\u0413\u0414\u0410\u041d\u041d\u042b\u0425\u041f\u041e\u041b\u042c\u0417\u041e\u0412\u0410\u0422\u0415\u041b\u042f", "\u041d\u0430\u0447\u0430\u0442\u044c\u041f\u043e\u043b\u0443\u0447\u0435\u043d\u0438\u0435\u0420\u0430\u0431\u043e\u0447\u0435\u0433\u043e\u041a\u0430\u0442\u0430\u043b\u043e\u0433\u0430\u0414\u0430\u043d\u043d\u044b\u0445\u041f\u043e\u043b\u044c\u0437\u043e\u0432\u0430\u0442\u0435\u043b\u044f");
        this.pairMethods.put("USERDATAWORKDIR", "BeginGettingUserDataWorkDir");
        this.pairMethods.put("\u041f\u041e\u041b\u0423\u0427\u0418\u0422\u042c\u0424\u0410\u0419\u041b\u042b", "\u041d\u0430\u0447\u0430\u0442\u044c\u041f\u043e\u043b\u0443\u0447\u0435\u043d\u0438\u0435\u0424\u0430\u0439\u043b\u043e\u0432");
        this.pairMethods.put("GETFILES", "BeginGettingFiles");
        this.pairMethods.put("\u041f\u041e\u041c\u0415\u0421\u0422\u0418\u0422\u042c\u0424\u0410\u0419\u041b\u042b", "\u041d\u0430\u0447\u0430\u0442\u044c\u041f\u043e\u043c\u0435\u0449\u0435\u043d\u0438\u0435\u0424\u0430\u0439\u043b\u043e\u0432");
        this.pairMethods.put("PUTFILES", "BeginPuttingFiles");
        this.pairMethods.put("\u0417\u0410\u041f\u0420\u041e\u0421\u0418\u0422\u042c\u0420\u0410\u0417\u0420\u0415\u0428\u0415\u041d\u0418\u0415\u041f\u041e\u041b\u042c\u0417\u041e\u0412\u0410\u0422\u0415\u041b\u042f", "\u041d\u0430\u0447\u0430\u0442\u044c\u0417\u0430\u043f\u0440\u043e\u0441\u0420\u0430\u0437\u0440\u0435\u0448\u0435\u043d\u0438\u044f\u041f\u043e\u043b\u044c\u0437\u043e\u0432\u0430\u0442\u0435\u043b\u044f");
        this.pairMethods.put("REQUESTUSERPERMISSION", "BeginRequestingUserPermission");
        this.pairMethods.put("\u0417\u0410\u041f\u0423\u0421\u0422\u0418\u0422\u042c\u041f\u0420\u0418\u041b\u041e\u0416\u0415\u041d\u0418\u0415", "\u041d\u0430\u0447\u0430\u0442\u044c\u0417\u0430\u043f\u0443\u0441\u043a\u041f\u0440\u0438\u043b\u043e\u0436\u0435\u043d\u0438\u044f");
        this.pairMethods.put("RUNAPP", "BeginRunningApplication");
    }

    public ParseTree visitFile(BSLParser.FileContext ctx) {
        Configuration configuration = this.documentContext.getServerContext().getConfiguration();
        if (configuration.getSynchronousExtensionAndAddInCallUseMode() == UseMode.USE) {
            return ctx;
        }
        return (ParseTree)super.visitFile(ctx);
    }

    public ParseTree visitSub(BSLParser.SubContext ctx) {
        Optional<CompilerDirectiveKind> compilerDirective;
        Optional<MethodSymbol> methodSymbol = this.documentContext.getSymbolTree().getMethodSymbol((BSLParserRuleContext)ctx);
        if (methodSymbol.isPresent() && (compilerDirective = methodSymbol.get().getCompilerDirectiveKind()).isPresent() && serverCompilerDirectives.contains((Object)compilerDirective.get())) {
            return ctx;
        }
        return (ParseTree)super.visitSub(ctx);
    }

    public ParseTree visitGlobalMethodCall(BSLParser.GlobalMethodCallContext ctx) {
        String methodName = ctx.methodName().getText();
        if (MODALITY_METHODS.matcher(methodName).matches()) {
            this.diagnosticStorage.addDiagnostic((BSLParserRuleContext)ctx, this.info.getMessage(methodName, this.pairMethods.get(methodName.toUpperCase(Locale.ENGLISH))));
        }
        return (ParseTree)super.visitGlobalMethodCall(ctx);
    }
}

