/*
 * Decompiled with CFR 0.152.
 */
package com.github._1c_syntax.bsl.languageserver.diagnostics.metadata;

import com.github._1c_syntax.bsl.languageserver.configuration.Language;
import com.github._1c_syntax.bsl.languageserver.configuration.LanguageServerConfiguration;
import com.github._1c_syntax.bsl.languageserver.diagnostics.BSLDiagnostic;
import com.github._1c_syntax.bsl.languageserver.diagnostics.metadata.DiagnosticCode;
import com.github._1c_syntax.bsl.languageserver.diagnostics.metadata.DiagnosticCompatibilityMode;
import com.github._1c_syntax.bsl.languageserver.diagnostics.metadata.DiagnosticMetadata;
import com.github._1c_syntax.bsl.languageserver.diagnostics.metadata.DiagnosticParameterInfo;
import com.github._1c_syntax.bsl.languageserver.diagnostics.metadata.DiagnosticScope;
import com.github._1c_syntax.bsl.languageserver.diagnostics.metadata.DiagnosticSeverity;
import com.github._1c_syntax.bsl.languageserver.diagnostics.metadata.DiagnosticTag;
import com.github._1c_syntax.bsl.languageserver.diagnostics.metadata.DiagnosticType;
import com.github._1c_syntax.bsl.languageserver.utils.Resources;
import com.github._1c_syntax.bsl.types.ModuleType;
import com.github._1c_syntax.utils.StringInterner;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.io.IOException;
import java.io.InputStream;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.EnumMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Collectors;
import lombok.Generated;
import org.apache.commons.io.IOUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DiagnosticInfo {
    @SuppressFBWarnings(justification="generated code")
    @Generated
    private static final Logger LOGGER = LoggerFactory.getLogger(DiagnosticInfo.class);
    private static final Map<DiagnosticSeverity, org.eclipse.lsp4j.DiagnosticSeverity> severityToLSPSeverityMap = DiagnosticInfo.createSeverityToLSPSeverityMap();
    private static final Map<DiagnosticTag, org.eclipse.lsp4j.DiagnosticTag> diagnosticTagMap = DiagnosticInfo.createDiagnosticTagMap();
    private final Class<? extends BSLDiagnostic> diagnosticClass;
    private final LanguageServerConfiguration configuration;
    private final StringInterner stringInterner;
    private final DiagnosticCode diagnosticCode;
    private final DiagnosticMetadata diagnosticMetadata;
    private final List<DiagnosticParameterInfo> diagnosticParameters;

    public DiagnosticInfo(Class<? extends BSLDiagnostic> diagnosticClass, LanguageServerConfiguration configuration, StringInterner stringInterner) {
        this.diagnosticClass = diagnosticClass;
        this.configuration = configuration;
        this.stringInterner = stringInterner;
        this.diagnosticCode = this.createDiagnosticCode();
        this.diagnosticMetadata = diagnosticClass.getAnnotation(DiagnosticMetadata.class);
        this.diagnosticParameters = DiagnosticParameterInfo.createDiagnosticParameters(this);
    }

    public Class<? extends BSLDiagnostic> getDiagnosticClass() {
        return this.diagnosticClass;
    }

    public DiagnosticCode getCode() {
        return this.diagnosticCode;
    }

    public String getDiagnosticCodeDescriptionHref() {
        Language language = this.configuration.getLanguage();
        boolean useDevSite = this.configuration.isUseDevSite();
        String siteRoot = this.configuration.getSiteRoot();
        String devSuffix = useDevSite ? "/dev" : "";
        String languageSuffix = language == Language.EN ? "/en" : "";
        String siteDiagnosticsUrl = String.format("%s%s%s/diagnostics/", siteRoot, devSuffix, languageSuffix);
        return this.stringInterner.intern(siteDiagnosticsUrl + this.diagnosticCode.getStringValue());
    }

    public String getName() {
        return this.getResourceString("diagnosticName");
    }

    public String getDescription() {
        String langCode = this.configuration.getLanguage().getLanguageCode();
        String resourceName = langCode + "/" + this.diagnosticCode.getStringValue() + ".md";
        InputStream descriptionStream = this.diagnosticClass.getResourceAsStream(resourceName);
        if (descriptionStream == null) {
            LOGGER.error("Can't find resource {}", (Object)resourceName);
            return "";
        }
        try {
            return IOUtils.toString((InputStream)descriptionStream, (Charset)StandardCharsets.UTF_8);
        }
        catch (IOException e) {
            LOGGER.error("Can't read diagnostic description", (Throwable)e);
            return "";
        }
    }

    public String getMessage() {
        return this.getResourceString("diagnosticMessage");
    }

    public String getMessage(Object ... args) {
        return this.getResourceString("diagnosticMessage", args);
    }

    public String getResourceString(String key) {
        return Resources.getResourceString(this.configuration.getLanguage(), this.diagnosticClass, key);
    }

    public String getResourceString(String key, Object ... args) {
        return Resources.getResourceString(this.configuration.getLanguage(), this.diagnosticClass, key, args);
    }

    public DiagnosticType getType() {
        return this.diagnosticMetadata.type();
    }

    public DiagnosticSeverity getSeverity() {
        return this.diagnosticMetadata.severity();
    }

    public org.eclipse.lsp4j.DiagnosticSeverity getLSPSeverity() {
        DiagnosticType type = this.getType();
        if (type == DiagnosticType.CODE_SMELL) {
            return severityToLSPSeverityMap.get((Object)this.getSeverity());
        }
        if (type == DiagnosticType.SECURITY_HOTSPOT) {
            return org.eclipse.lsp4j.DiagnosticSeverity.Warning;
        }
        return org.eclipse.lsp4j.DiagnosticSeverity.Error;
    }

    public DiagnosticCompatibilityMode getCompatibilityMode() {
        return this.diagnosticMetadata.compatibilityMode();
    }

    public DiagnosticScope getScope() {
        return this.diagnosticMetadata.scope();
    }

    public ModuleType[] getModules() {
        return this.diagnosticMetadata.modules();
    }

    public int getMinutesToFix() {
        return this.diagnosticMetadata.minutesToFix();
    }

    public boolean isActivatedByDefault() {
        return this.diagnosticMetadata.activatedByDefault();
    }

    public List<DiagnosticTag> getTags() {
        return new ArrayList<DiagnosticTag>(Arrays.asList(this.diagnosticMetadata.tags()));
    }

    public List<org.eclipse.lsp4j.DiagnosticTag> getLSPTags() {
        return this.getTags().stream().map(diagnosticTag -> diagnosticTagMap.getOrDefault(diagnosticTag, null)).filter(Objects::nonNull).collect(Collectors.toList());
    }

    public List<DiagnosticParameterInfo> getParameters() {
        return new ArrayList<DiagnosticParameterInfo>(this.diagnosticParameters);
    }

    public Optional<DiagnosticParameterInfo> getParameter(String parameterName) {
        return this.diagnosticParameters.stream().filter(param -> param.getName().equals(parameterName)).findAny();
    }

    public Map<String, Object> getDefaultConfiguration() {
        return this.diagnosticParameters.stream().collect(Collectors.toMap(DiagnosticParameterInfo::getName, DiagnosticParameterInfo::getDefaultValue));
    }

    private DiagnosticCode createDiagnosticCode() {
        String simpleName = this.diagnosticClass.getSimpleName();
        if (simpleName.endsWith("Diagnostic")) {
            simpleName = simpleName.substring(0, simpleName.length() - "Diagnostic".length());
        }
        return new DiagnosticCode(this.stringInterner.intern(simpleName));
    }

    private static Map<DiagnosticSeverity, org.eclipse.lsp4j.DiagnosticSeverity> createSeverityToLSPSeverityMap() {
        EnumMap<DiagnosticSeverity, org.eclipse.lsp4j.DiagnosticSeverity> map = new EnumMap<DiagnosticSeverity, org.eclipse.lsp4j.DiagnosticSeverity>(DiagnosticSeverity.class);
        map.put(DiagnosticSeverity.INFO, org.eclipse.lsp4j.DiagnosticSeverity.Hint);
        map.put(DiagnosticSeverity.MINOR, org.eclipse.lsp4j.DiagnosticSeverity.Information);
        map.put(DiagnosticSeverity.MAJOR, org.eclipse.lsp4j.DiagnosticSeverity.Warning);
        map.put(DiagnosticSeverity.CRITICAL, org.eclipse.lsp4j.DiagnosticSeverity.Warning);
        map.put(DiagnosticSeverity.BLOCKER, org.eclipse.lsp4j.DiagnosticSeverity.Warning);
        return map;
    }

    private static Map<DiagnosticTag, org.eclipse.lsp4j.DiagnosticTag> createDiagnosticTagMap() {
        return Map.of(DiagnosticTag.UNUSED, org.eclipse.lsp4j.DiagnosticTag.Unnecessary, DiagnosticTag.DEPRECATED, org.eclipse.lsp4j.DiagnosticTag.Deprecated);
    }
}

