/*
 * Decompiled with CFR 0.152.
 */
package com.github._1c_syntax.bsl.languageserver.providers;

import com.github._1c_syntax.bsl.languageserver.context.DocumentContext;
import com.github._1c_syntax.bsl.languageserver.utils.Ranges;
import com.github._1c_syntax.bsl.languageserver.utils.Trees;
import com.github._1c_syntax.bsl.parser.BSLParser;
import com.github._1c_syntax.bsl.parser.BSLParserRuleContext;
import edu.umd.cs.findbugs.annotations.Nullable;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import org.antlr.v4.runtime.ParserRuleContext;
import org.antlr.v4.runtime.RuleContext;
import org.antlr.v4.runtime.tree.ParseTree;
import org.antlr.v4.runtime.tree.Tree;
import org.eclipse.lsp4j.Range;
import org.eclipse.lsp4j.SelectionRange;
import org.eclipse.lsp4j.SelectionRangeParams;
import org.springframework.stereotype.Component;

@Component
public class SelectionRangeProvider {
    private static final Set<Integer> SKIPPED_NODES = Set.of(102, 99, 93, 57, 58, 103, 51, 47, 52, 53, 54, 55, 44, 45, 46, 56, 61, 66, 67, 81);

    public List<SelectionRange> getSelectionRange(DocumentContext documentContext, SelectionRangeParams params) {
        List positions = params.getPositions();
        BSLParser.FileContext ast = documentContext.getAst();
        return positions.stream().map(position -> Trees.findTerminalNodeContainsPosition((BSLParserRuleContext)ast, position)).map(terminalNode -> terminalNode.orElse(null)).map(SelectionRangeProvider::toSelectionRange).collect(Collectors.toList());
    }

    @Nullable
    private static SelectionRange toSelectionRange(@Nullable ParseTree node) {
        if (node == null) {
            return null;
        }
        Range range = Ranges.create(node);
        SelectionRange selectionRange = new SelectionRange();
        selectionRange.setRange(range);
        SelectionRangeProvider.nextParentWithDifferentRange(node).map(SelectionRangeProvider::toSelectionRange).ifPresent(arg_0 -> ((SelectionRange)selectionRange).setParent(arg_0));
        return selectionRange;
    }

    private static Optional<ParseTree> nextParentWithDifferentRange(ParseTree ctx) {
        BSLParserRuleContext parent = SelectionRangeProvider.getParentContext(ctx);
        if (parent == null) {
            return Optional.empty();
        }
        boolean needToSkipNode = SKIPPED_NODES.contains(parent.getRuleIndex());
        needToSkipNode = needToSkipNode || SelectionRangeProvider.ifBranchMatchesIfStatement(parent);
        Range currentRange = Ranges.create(ctx);
        Range parentRange = Ranges.create((ParserRuleContext)parent);
        if (needToSkipNode || parentRange.equals((Object)currentRange)) {
            return SelectionRangeProvider.nextParentWithDifferentRange((ParseTree)parent);
        }
        return Optional.of(parent);
    }

    private static BSLParserRuleContext getParentContext(ParseTree ctx) {
        if (ctx instanceof BSLParser.StatementContext) {
            return SelectionRangeProvider.getStatementParent((BSLParser.StatementContext)ctx);
        }
        return SelectionRangeProvider.getDefaultParent(ctx);
    }

    @Nullable
    private static BSLParserRuleContext getDefaultParent(ParseTree ctx) {
        return (BSLParserRuleContext)ctx.getParent();
    }

    private static BSLParserRuleContext getStatementParent(BSLParser.StatementContext statement) {
        BSLParserRuleContext child;
        int i;
        BSLParserRuleContext parent = SelectionRangeProvider.getDefaultParent((ParseTree)statement);
        int statementLine = statement.getStart().getLine();
        BSLParser.CodeBlockContext codeBlock = (BSLParser.CodeBlockContext)statement.getParent();
        List<Tree> children = Trees.getChildren((Tree)codeBlock);
        int currentPosition = children.indexOf(statement);
        ArrayList<Object> nearbyStatements = new ArrayList<Object>();
        int localLine = statementLine;
        for (i = currentPosition + 1; i < children.size() && (child = (BSLParserRuleContext)children.get(i)).getStart().getLine() == localLine + 1; ++i) {
            nearbyStatements.add(child);
            ++localLine;
        }
        localLine = statementLine;
        for (i = currentPosition - 1; i >= 0 && (child = (BSLParserRuleContext)children.get(i)).getStart().getLine() == localLine - 1; --i) {
            nearbyStatements.add(child);
            --localLine;
        }
        if (!nearbyStatements.isEmpty() && nearbyStatements.size() + 1 != children.size()) {
            BSLParserRuleContext statementsBlock = new BSLParserRuleContext();
            statementsBlock.setParent((RuleContext)parent);
            nearbyStatements.add(statement);
            nearbyStatements.sort(Comparator.comparing(ruleContext -> ruleContext.getStart().getLine()));
            nearbyStatements.forEach(ruleContext -> ruleContext.setParent((RuleContext)statementsBlock));
            nearbyStatements.forEach(arg_0 -> ((BSLParserRuleContext)statementsBlock).addChild(arg_0));
            nearbyStatements.forEach(ruleContext -> ruleContext.setParent((RuleContext)codeBlock));
            statementsBlock.start = ((ParserRuleContext)nearbyStatements.get(0)).getStart();
            statementsBlock.stop = ((ParserRuleContext)nearbyStatements.get(nearbyStatements.size() - 1)).getStop();
            parent = statementsBlock;
        }
        return parent;
    }

    private static boolean ifBranchMatchesIfStatement(BSLParserRuleContext ctx) {
        if (!(ctx instanceof BSLParser.IfBranchContext)) {
            return false;
        }
        BSLParser.IfBranchContext ifBranch = (BSLParser.IfBranchContext)ctx;
        BSLParser.IfStatementContext ifStatement = (BSLParser.IfStatementContext)ifBranch.getParent();
        return ifStatement.elseBranch() == null && ifStatement.elsifBranch().isEmpty();
    }
}

