/*
 * Decompiled with CFR 0.152.
 */
package com.github._1c_syntax.bsl.languageserver.recognizer;

import com.github._1c_syntax.bsl.languageserver.recognizer.AbstractDetector;
import com.github._1c_syntax.bsl.languageserver.recognizer.LanguageFootprint;

public class CodeRecognizer {
    private final LanguageFootprint language;
    private final double threshold;

    public CodeRecognizer(double threshold, LanguageFootprint language) {
        this.language = language;
        this.threshold = threshold;
    }

    private double recognition(String line) {
        double probability = 0.0;
        for (AbstractDetector pattern : this.language.getDetectors()) {
            probability = 1.0 - (1.0 - probability) * (1.0 - pattern.detect(line));
        }
        return probability;
    }

    public final boolean meetsCondition(String line) {
        return this.recognition(line) - this.threshold > 0.0;
    }
}

