/*
 * Decompiled with CFR 0.152.
 */
package com.github._1c_syntax.bsl.languageserver.references.model;

import com.github._1c_syntax.bsl.languageserver.utils.Ranges;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.beans.ConstructorProperties;
import java.net.URI;
import lombok.Generated;
import org.eclipse.lsp4j.Position;
import org.eclipse.lsp4j.Range;

public final class Location {
    private final URI uri;
    private final int startLine;
    private final int startCharacter;
    private final int endLine;
    private final int endCharacter;

    public Location(URI uri, Range range) {
        this.uri = uri;
        Position start = range.getStart();
        Position end = range.getEnd();
        this.startLine = start.getLine();
        this.startCharacter = start.getCharacter();
        this.endLine = end.getLine();
        this.endCharacter = end.getCharacter();
    }

    public Range getRange() {
        return Ranges.create(this.startLine, this.startCharacter, this.endLine, this.endCharacter);
    }

    @SuppressFBWarnings(justification="generated code")
    @Generated
    public static LocationBuilder builder() {
        return new LocationBuilder();
    }

    @SuppressFBWarnings(justification="generated code")
    @Generated
    public URI getUri() {
        return this.uri;
    }

    @SuppressFBWarnings(justification="generated code")
    @Generated
    public int getStartLine() {
        return this.startLine;
    }

    @SuppressFBWarnings(justification="generated code")
    @Generated
    public int getStartCharacter() {
        return this.startCharacter;
    }

    @SuppressFBWarnings(justification="generated code")
    @Generated
    public int getEndLine() {
        return this.endLine;
    }

    @SuppressFBWarnings(justification="generated code")
    @Generated
    public int getEndCharacter() {
        return this.endCharacter;
    }

    @SuppressFBWarnings(justification="generated code")
    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof Location)) {
            return false;
        }
        Location other = (Location)o;
        if (this.getStartLine() != other.getStartLine()) {
            return false;
        }
        if (this.getStartCharacter() != other.getStartCharacter()) {
            return false;
        }
        if (this.getEndLine() != other.getEndLine()) {
            return false;
        }
        if (this.getEndCharacter() != other.getEndCharacter()) {
            return false;
        }
        URI this$uri = this.getUri();
        URI other$uri = other.getUri();
        return !(this$uri == null ? other$uri != null : !((Object)this$uri).equals(other$uri));
    }

    @SuppressFBWarnings(justification="generated code")
    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + this.getStartLine();
        result = result * 59 + this.getStartCharacter();
        result = result * 59 + this.getEndLine();
        result = result * 59 + this.getEndCharacter();
        URI $uri = this.getUri();
        result = result * 59 + ($uri == null ? 43 : ((Object)$uri).hashCode());
        return result;
    }

    @SuppressFBWarnings(justification="generated code")
    @Generated
    public String toString() {
        return "Location(uri=" + this.getUri() + ", startLine=" + this.getStartLine() + ", startCharacter=" + this.getStartCharacter() + ", endLine=" + this.getEndLine() + ", endCharacter=" + this.getEndCharacter() + ")";
    }

    @ConstructorProperties(value={"uri", "startLine", "startCharacter", "endLine", "endCharacter"})
    @SuppressFBWarnings(justification="generated code")
    @Generated
    public Location(URI uri, int startLine, int startCharacter, int endLine, int endCharacter) {
        this.uri = uri;
        this.startLine = startLine;
        this.startCharacter = startCharacter;
        this.endLine = endLine;
        this.endCharacter = endCharacter;
    }

    @SuppressFBWarnings(justification="generated code")
    @Generated
    public static class LocationBuilder {
        @SuppressFBWarnings(justification="generated code")
        @Generated
        private URI uri;
        @SuppressFBWarnings(justification="generated code")
        @Generated
        private int startLine;
        @SuppressFBWarnings(justification="generated code")
        @Generated
        private int startCharacter;
        @SuppressFBWarnings(justification="generated code")
        @Generated
        private int endLine;
        @SuppressFBWarnings(justification="generated code")
        @Generated
        private int endCharacter;

        @SuppressFBWarnings(justification="generated code")
        @Generated
        LocationBuilder() {
        }

        @SuppressFBWarnings(justification="generated code")
        @Generated
        public LocationBuilder uri(URI uri) {
            this.uri = uri;
            return this;
        }

        @SuppressFBWarnings(justification="generated code")
        @Generated
        public LocationBuilder startLine(int startLine) {
            this.startLine = startLine;
            return this;
        }

        @SuppressFBWarnings(justification="generated code")
        @Generated
        public LocationBuilder startCharacter(int startCharacter) {
            this.startCharacter = startCharacter;
            return this;
        }

        @SuppressFBWarnings(justification="generated code")
        @Generated
        public LocationBuilder endLine(int endLine) {
            this.endLine = endLine;
            return this;
        }

        @SuppressFBWarnings(justification="generated code")
        @Generated
        public LocationBuilder endCharacter(int endCharacter) {
            this.endCharacter = endCharacter;
            return this;
        }

        @SuppressFBWarnings(justification="generated code")
        @Generated
        public Location build() {
            return new Location(this.uri, this.startLine, this.startCharacter, this.endLine, this.endCharacter);
        }

        @SuppressFBWarnings(justification="generated code")
        @Generated
        public String toString() {
            return "Location.LocationBuilder(uri=" + this.uri + ", startLine=" + this.startLine + ", startCharacter=" + this.startCharacter + ", endLine=" + this.endLine + ", endCharacter=" + this.endCharacter + ")";
        }
    }
}

