/*
 * Decompiled with CFR 0.152.
 */
package com.github._1c_syntax.bsl.languageserver.reporters;

import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.SerializationFeature;
import com.github._1c_syntax.bsl.languageserver.reporters.DiagnosticReporter;
import com.github._1c_syntax.bsl.languageserver.reporters.TSLintReportEntry;
import com.github._1c_syntax.bsl.languageserver.reporters.data.AnalysisInfo;
import com.github._1c_syntax.bsl.languageserver.reporters.data.FileInfo;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.io.File;
import java.nio.file.Path;
import java.util.ArrayList;
import lombok.Generated;
import org.eclipse.lsp4j.Diagnostic;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Component;

@Component
public class TSLintReporter
implements DiagnosticReporter {
    @SuppressFBWarnings(justification="generated code")
    @Generated
    private static final Logger LOGGER = LoggerFactory.getLogger(TSLintReporter.class);

    @Override
    public String key() {
        return "tslint";
    }

    @Override
    public void report(AnalysisInfo analysisInfo, Path outputDir) {
        ArrayList<TSLintReportEntry> tsLintReport = new ArrayList<TSLintReportEntry>();
        for (FileInfo fileInfo : analysisInfo.getFileinfos()) {
            for (Diagnostic diagnostic : fileInfo.getDiagnostics()) {
                TSLintReportEntry entry = new TSLintReportEntry(fileInfo.getPath().toString(), diagnostic);
                tsLintReport.add(entry);
            }
        }
        ObjectMapper mapper = new ObjectMapper();
        mapper.enable(SerializationFeature.INDENT_OUTPUT);
        File reportFile = new File(outputDir.toFile(), "./bsl-tslint.json");
        mapper.writeValue(reportFile, tsLintReport);
        LOGGER.info("TSLint report saved to {}", (Object)reportFile.getAbsolutePath());
    }
}

