/*
 * Decompiled with CFR 0.152.
 */
package com.github._1c_syntax.bsl.languageserver.utils;

import com.github._1c_syntax.bsl.languageserver.utils.NotifyDescription;
import com.github._1c_syntax.bsl.parser.BSLParser;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import lombok.Generated;
import org.antlr.v4.runtime.ParserRuleContext;
import org.antlr.v4.runtime.Token;

public final class Methods {
    public static Optional<Token> getMethodName(BSLParser.CallStatementContext ctx) {
        List modifiers = ctx.modifier();
        Optional<Token> methodName = ctx.globalMethodCall() != null ? Methods.getMethodName(ctx.globalMethodCall()) : Methods.getMethodName(ctx.accessCall());
        if (modifiers.isEmpty()) {
            return methodName;
        }
        return Methods.getMethodName(modifiers).or(() -> methodName);
    }

    public static Optional<Token> getMethodName(BSLParser.GlobalMethodCallContext ctx) {
        return Optional.of(ctx.methodName().getStart());
    }

    public static Optional<Token> getMethodName(BSLParser.AccessCallContext ctx) {
        return Optional.of(ctx.methodCall().methodName().getStart());
    }

    public static Optional<Token> getMethodName(BSLParser.ComplexIdentifierContext ctx) {
        return Methods.getMethodName(ctx.modifier());
    }

    public static Optional<Token> getMethodName(List<? extends BSLParser.ModifierContext> modifiers) {
        return modifiers.stream().map(BSLParser.ModifierContext::accessCall).filter(Objects::nonNull).map(Methods::getMethodName).findFirst().orElse(Optional.empty());
    }

    public static Optional<Token> getMethodName(BSLParser.CallParamContext callParamContext) {
        return NotifyDescription.getFirstMember(callParamContext).map(BSLParser.MemberContext::constValue).map(BSLParser.ConstValueContext::string).map(ParserRuleContext::getStart);
    }

    public static Optional<Token> getMethodName(BSLParser.LValueContext lValueContext) {
        return Optional.ofNullable(lValueContext.acceptor()).map(BSLParser.AcceptorContext::modifier).flatMap(Methods::getMethodName);
    }

    @SuppressFBWarnings(justification="generated code")
    @Generated
    private Methods() {
        throw new UnsupportedOperationException("This is a utility class and cannot be instantiated");
    }
}

