/*
 * Decompiled with CFR 0.152.
 */
package com.github._1c_syntax.bsl.languageserver.utils;

import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.util.Collection;
import java.util.List;
import java.util.Optional;
import lombok.Generated;
import org.antlr.v4.runtime.ParserRuleContext;
import org.antlr.v4.runtime.Token;
import org.antlr.v4.runtime.tree.ParseTree;
import org.antlr.v4.runtime.tree.TerminalNode;
import org.eclipse.lsp4j.Position;
import org.eclipse.lsp4j.Range;

public final class Ranges {
    public static boolean isEmpty(Range range) {
        return Ranges.create().equals((Object)range);
    }

    public static Range create() {
        return Ranges.create(0, 0, 0, 0);
    }

    public static Range create(int startLine, int startChar, int endLine, int endChar) {
        return new Range(new Position(startLine, startChar), new Position(endLine, endChar));
    }

    public static Range create(int lineNo, int startChar, int endChar) {
        return new Range(new Position(lineNo, startChar), new Position(lineNo, endChar));
    }

    public static Range create(ParserRuleContext ruleContext) {
        return Ranges.create(ruleContext.getStart(), ruleContext.getStop());
    }

    public static Range create(ParserRuleContext startCtx, ParserRuleContext endCtx) {
        return Ranges.create(startCtx.getStart(), endCtx.getStop());
    }

    public static Range create(Token startToken, Token endToken) {
        int startLine = startToken.getLine() - 1;
        int startChar = startToken.getCharPositionInLine();
        Token tokenToCalculateEnd = endToken == null ? startToken : endToken;
        int endLine = tokenToCalculateEnd.getLine() - 1;
        int endChar = tokenToCalculateEnd.getType() == -1 ? tokenToCalculateEnd.getCharPositionInLine() : tokenToCalculateEnd.getCharPositionInLine() + tokenToCalculateEnd.getText().length();
        return Ranges.create(startLine, startChar, endLine, endChar);
    }

    public static Range create(List<Token> tokens) {
        if (tokens.isEmpty()) {
            return Ranges.create();
        }
        Token firstElement = tokens.get(0);
        Token lastElement = tokens.get(tokens.size() - 1);
        return Ranges.create(firstElement, lastElement);
    }

    public static Range create(TerminalNode terminalNode) {
        return Ranges.create(terminalNode.getSymbol());
    }

    public static Range create(TerminalNode startTerminalNode, TerminalNode stopTerminalNode) {
        return Ranges.create(startTerminalNode.getSymbol(), stopTerminalNode.getSymbol());
    }

    public static Range create(Token token) {
        int startLine = token.getLine() - 1;
        int startChar = token.getCharPositionInLine();
        int endLine = token.getLine() - 1;
        int endChar = token.getCharPositionInLine() + token.getText().length();
        return Ranges.create(startLine, startChar, endLine, endChar);
    }

    public static Range create(ParseTree tree) {
        if (tree instanceof TerminalNode) {
            return Ranges.create((TerminalNode)tree);
        }
        if (tree instanceof Token) {
            return Ranges.create((Token)tree);
        }
        if (tree instanceof ParserRuleContext) {
            return Ranges.create((ParserRuleContext)tree);
        }
        throw new IllegalArgumentException();
    }

    public static boolean containsRange(Range bigger, Range smaller) {
        return org.eclipse.lsp4j.util.Ranges.containsRange((Range)bigger, (Range)smaller);
    }

    public static boolean containsPosition(Range range, Position position) {
        return org.eclipse.lsp4j.util.Ranges.containsPosition((Range)range, (Position)position);
    }

    public static int compare(Range o1, Range o2) {
        if (o1.equals((Object)o2)) {
            return 0;
        }
        int startCompare = Ranges.compare(o1.getStart(), o2.getStart());
        if (startCompare != 0) {
            return startCompare;
        }
        return Ranges.compare(o1.getEnd(), o2.getEnd());
    }

    public static int compare(Position pos1, Position pos2) {
        if (pos1.equals((Object)pos2)) {
            return 0;
        }
        if (pos1.getLine() < pos2.getLine()) {
            return -1;
        }
        if (pos1.getLine() > pos2.getLine()) {
            return 1;
        }
        return Integer.compare(pos1.getCharacter(), pos2.getCharacter());
    }

    @Deprecated(since="0.20")
    public static Optional<Range> getFirstSignificantTokenRange(Collection<Token> tokens) {
        return tokens.stream().filter(token -> token.getType() != -1).filter(token -> token.getType() != 2).map(Ranges::create).filter(range -> !range.getStart().equals((Object)range.getEnd())).findFirst();
    }

    @SuppressFBWarnings(justification="generated code")
    @Generated
    private Ranges() {
        throw new UnsupportedOperationException("This is a utility class and cannot be instantiated");
    }
}

