/*
 * Decompiled with CFR 0.152.
 */
package com.github._1c_syntax.bsl.languageserver.utils.expressiontree;

import com.github._1c_syntax.bsl.languageserver.utils.expressiontree.AbstractCallNode;
import com.github._1c_syntax.bsl.languageserver.utils.expressiontree.BinaryOperationNode;
import com.github._1c_syntax.bsl.languageserver.utils.expressiontree.BslExpression;
import com.github._1c_syntax.bsl.languageserver.utils.expressiontree.BslOperator;
import com.github._1c_syntax.bsl.languageserver.utils.expressiontree.ConstructorCallNode;
import com.github._1c_syntax.bsl.languageserver.utils.expressiontree.ExpressionParseTreeRewriter;
import com.github._1c_syntax.bsl.languageserver.utils.expressiontree.MethodCallNode;
import com.github._1c_syntax.bsl.languageserver.utils.expressiontree.SkippedCallArgumentNode;
import com.github._1c_syntax.bsl.languageserver.utils.expressiontree.TerminalSymbolNode;
import com.github._1c_syntax.bsl.languageserver.utils.expressiontree.TernaryOperatorNode;
import com.github._1c_syntax.bsl.languageserver.utils.expressiontree.UnaryOperationNode;
import com.github._1c_syntax.bsl.parser.BSLParser;
import com.github._1c_syntax.bsl.parser.BSLParserBaseVisitor;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.beans.ConstructorProperties;
import java.util.ArrayDeque;
import java.util.Collections;
import java.util.Deque;
import java.util.List;
import java.util.stream.Collectors;
import lombok.Generated;
import org.antlr.v4.runtime.tree.ParseTree;
import org.antlr.v4.runtime.tree.ParseTreeVisitor;
import org.antlr.v4.runtime.tree.TerminalNode;

class ExpressionTreeBuildingVisitor
extends BSLParserBaseVisitor<ParseTree> {
    private final Deque<BslExpression> operands = new ArrayDeque<BslExpression>();
    private final Deque<OperatorInCode> operatorsInFly = new ArrayDeque<OperatorInCode>();
    private BslExpression resultExpression;
    private int recursionLevel = -1;

    ExpressionTreeBuildingVisitor() {
    }

    public BslExpression getExpressionTree() {
        return this.resultExpression;
    }

    public ParseTree visitExpression(BSLParser.ExpressionContext ctx) {
        boolean addToOperands;
        int nestingCount = this.operatorsInFly.size();
        ++this.recursionLevel;
        this.visitMember(ctx.member(0));
        int count = ctx.getChildCount();
        if (count > 1) {
            for (int i = 1; i < count; ++i) {
                ParseTree child = ctx.getChild(i);
                if (child.getClass() == BSLParser.OperationContext.class) {
                    this.visitOperation((BSLParser.OperationContext)child);
                    continue;
                }
                if (child.getClass() == BSLParser.MemberContext.class) {
                    this.visitMember((BSLParser.MemberContext)child);
                    continue;
                }
                if (child.getClass() == BSLParser.PreprocessorContext.class) continue;
                throw new IllegalStateException();
            }
        }
        boolean bl = addToOperands = this.recursionLevel > 0;
        while (nestingCount < this.operatorsInFly.size()) {
            this.buildOperation();
        }
        BslExpression operation = this.operands.peek();
        assert (operation != null);
        if (operation.getRepresentingAst() == null) {
            operation.setRepresentingAst((ParseTree)ctx);
        }
        if (!addToOperands) {
            this.resultExpression = this.operands.pop();
        }
        --this.recursionLevel;
        return ctx;
    }

    public ParseTree visitMember(BSLParser.MemberContext ctx) {
        ParseTree dispatchChild;
        BSLParser.UnaryModifierContext unaryModifier = ctx.unaryModifier();
        int childIndex = 0;
        if (unaryModifier != null) {
            this.visitUnaryModifier(unaryModifier);
            childIndex = 1;
        }
        if ((dispatchChild = ctx.getChild(childIndex)) instanceof TerminalNode) {
            int token = ((TerminalNode)dispatchChild).getSymbol().getType();
            switch (token) {
                case 6: {
                    this.visitParenthesis(ctx.expression(), ctx.modifier());
                    break;
                }
                case 126: {
                    this.visitAwaitedMember(ctx.getChild(childIndex + 1));
                    break;
                }
                default: {
                    throw new IllegalStateException("Unexpected rule " + dispatchChild);
                }
            }
        } else {
            dispatchChild.accept((ParseTreeVisitor)this);
        }
        if (unaryModifier != null) {
            this.buildOperation();
        }
        return ctx;
    }

    private void visitParenthesis(BSLParser.ExpressionContext expression, List<? extends BSLParser.ModifierContext> modifiers) {
        BslExpression subExpr = ExpressionTreeBuildingVisitor.makeSubexpression(expression);
        this.operands.push(subExpr);
        for (BSLParser.ModifierContext modifierContext : modifiers) {
            modifierContext.accept((ParseTreeVisitor)this);
        }
    }

    private void visitAwaitedMember(ParseTree child) {
        child.accept((ParseTreeVisitor)this);
    }

    public ParseTree visitOperation(BSLParser.OperationContext ctx) {
        BslOperator operator = ExpressionTreeBuildingVisitor.getOperator(ctx);
        this.processOperation(new OperatorInCode(operator, (ParseTree)ctx));
        return ctx;
    }

    private void processOperation(OperatorInCode operator) {
        if (this.operatorsInFly.isEmpty()) {
            this.operatorsInFly.push(operator);
            return;
        }
        OperatorInCode lastSeenOperator = this.operatorsInFly.peek();
        if (lastSeenOperator.getPriority() > operator.getPriority()) {
            this.buildOperation();
        }
        this.operatorsInFly.push(operator);
    }

    private static BslOperator getOperator(BSLParser.OperationContext ctx) {
        if (ctx.PLUS() != null) {
            return BslOperator.ADD;
        }
        if (ctx.MINUS() != null) {
            return BslOperator.SUBTRACT;
        }
        if (ctx.MUL() != null) {
            return BslOperator.MULTIPLY;
        }
        if (ctx.QUOTIENT() != null) {
            return BslOperator.DIVIDE;
        }
        if (ctx.MODULO() != null) {
            return BslOperator.MODULO;
        }
        if (ctx.boolOperation() != null) {
            if (ctx.boolOperation().AND_KEYWORD() != null) {
                return BslOperator.AND;
            }
            return BslOperator.OR;
        }
        if (ctx.compareOperation() != null) {
            int token = ((TerminalNode)ctx.compareOperation().getChild(0)).getSymbol().getType();
            switch (token) {
                case 11: {
                    return BslOperator.EQUAL;
                }
                case 15: {
                    return BslOperator.NOT_EQUAL;
                }
                case 16: {
                    return BslOperator.LESS;
                }
                case 14: {
                    return BslOperator.LESS_OR_EQUAL;
                }
                case 18: {
                    return BslOperator.GREATER;
                }
                case 17: {
                    return BslOperator.GREATER_OR_EQUAL;
                }
            }
        }
        throw new IllegalStateException();
    }

    public ParseTree visitConstValue(BSLParser.ConstValueContext ctx) {
        TerminalSymbolNode node = TerminalSymbolNode.literal(ctx);
        this.operands.push(node);
        return ctx;
    }

    public ParseTree visitUnaryModifier(BSLParser.UnaryModifierContext ctx) {
        TerminalNode child = (TerminalNode)ctx.getChild(0);
        int token = child.getSymbol().getType();
        this.operatorsInFly.push(new OperatorInCode(switch (token) {
            case 12 -> BslOperator.UNARY_PLUS;
            case 13 -> BslOperator.UNARY_MINUS;
            case 66 -> BslOperator.NOT;
            default -> throw new IllegalArgumentException();
        }, (ParseTree)child));
        return ctx;
    }

    public ParseTree visitComplexIdentifier(BSLParser.ComplexIdentifierContext ctx) {
        if (ctx.IDENTIFIER() != null) {
            this.operands.push(TerminalSymbolNode.identifier(ctx.IDENTIFIER()));
        } else {
            ParseTree childVariant = (ParseTree)ctx.children.get(0);
            childVariant.accept((ParseTreeVisitor)this);
        }
        List modifiers = ctx.modifier();
        for (BSLParser.ModifierContext modifier : modifiers) {
            modifier.accept((ParseTreeVisitor)this);
        }
        return ctx;
    }

    public ParseTree visitGlobalMethodCall(BSLParser.GlobalMethodCallContext ctx) {
        TerminalNode name = ctx.methodName().IDENTIFIER();
        MethodCallNode callNode = MethodCallNode.create(name);
        callNode.setRepresentingAst((ParseTree)ctx);
        BSLParser.CallParamListContext paramList = ctx.doCall().callParamList();
        List parameters = paramList.callParam();
        ExpressionTreeBuildingVisitor.addCallArguments(callNode, parameters);
        this.operands.push(callNode);
        return ctx;
    }

    public ParseTree visitNewExpression(BSLParser.NewExpressionContext ctx) {
        ConstructorCallNode callNode;
        BSLParser.TypeNameContext typeName = ctx.typeName();
        BSLParser.DoCallContext call = ctx.doCall();
        List args = call == null ? Collections.emptyList() : ctx.doCall().callParamList().callParam();
        if (typeName == null) {
            BSLParser.CallParamContext typeNameArg = (BSLParser.CallParamContext)args.get(0);
            args = args.stream().skip(1L).collect(Collectors.toList());
            callNode = ConstructorCallNode.createDynamic(ExpressionTreeBuildingVisitor.makeSubexpression(typeNameArg.expression()));
        } else {
            TerminalSymbolNode typeNameTerminal = TerminalSymbolNode.literal(typeName.IDENTIFIER());
            callNode = ConstructorCallNode.createStatic(typeNameTerminal);
        }
        callNode.setRepresentingAst((ParseTree)ctx);
        ExpressionTreeBuildingVisitor.addCallArguments(callNode, args);
        this.operands.push(callNode);
        return ctx;
    }

    public ParseTree visitAccessProperty(BSLParser.AccessPropertyContext ctx) {
        BslExpression target = this.operands.pop();
        BinaryOperationNode operation = BinaryOperationNode.create(BslOperator.DEREFERENCE, target, TerminalSymbolNode.identifier(ctx.IDENTIFIER()), (ParseTree)ctx);
        this.operands.push(operation);
        return ctx;
    }

    public ParseTree visitAccessIndex(BSLParser.AccessIndexContext ctx) {
        BslExpression target = this.operands.pop();
        BslExpression expressionArg = ExpressionTreeBuildingVisitor.makeSubexpression(ctx.expression());
        BinaryOperationNode indexOperation = BinaryOperationNode.create(BslOperator.INDEX_ACCESS, target, expressionArg, (ParseTree)ctx);
        this.operands.push(indexOperation);
        return ctx;
    }

    public ParseTree visitAccessCall(BSLParser.AccessCallContext ctx) {
        BslExpression target = this.operands.pop();
        BSLParser.MethodCallContext methodCall = ctx.methodCall();
        MethodCallNode callNode = MethodCallNode.create(methodCall.methodName().IDENTIFIER());
        ExpressionTreeBuildingVisitor.addCallArguments(callNode, methodCall.doCall().callParamList().callParam());
        BinaryOperationNode operation = BinaryOperationNode.create(BslOperator.DEREFERENCE, target, callNode, (ParseTree)ctx);
        this.operands.push(operation);
        return ctx;
    }

    public ParseTree visitTernaryOperator(BSLParser.TernaryOperatorContext ctx) {
        TernaryOperatorNode ternary = TernaryOperatorNode.create(ExpressionTreeBuildingVisitor.makeSubexpression(ctx.expression(0)), ExpressionTreeBuildingVisitor.makeSubexpression(ctx.expression(1)), ExpressionTreeBuildingVisitor.makeSubexpression(ctx.expression(2)));
        ternary.setRepresentingAst((ParseTree)ctx);
        this.operands.push(ternary);
        return ctx;
    }

    private static BslExpression makeSubexpression(BSLParser.ExpressionContext ctx) {
        return ExpressionParseTreeRewriter.buildExpressionTree(ctx);
    }

    private static void addCallArguments(AbstractCallNode callNode, List<? extends BSLParser.CallParamContext> args) {
        for (BSLParser.CallParamContext callParamContext : args) {
            if (callParamContext.expression() == null) {
                callNode.addArgument(new SkippedCallArgumentNode());
                continue;
            }
            callNode.addArgument(ExpressionTreeBuildingVisitor.makeSubexpression(callParamContext.expression()));
        }
    }

    private void buildOperation() {
        if (this.operatorsInFly.isEmpty()) {
            return;
        }
        OperatorInCode operator = this.operatorsInFly.pop();
        switch (operator.getOperator()) {
            case UNARY_MINUS: 
            case UNARY_PLUS: 
            case NOT: {
                BslExpression operand = this.operands.pop();
                UnaryOperationNode operation = UnaryOperationNode.create(operator.getOperator(), operand, operator.getActualSourceCode());
                this.operands.push(operation);
                break;
            }
            default: {
                BslExpression right = this.operands.pop();
                BslExpression left = this.operands.pop();
                BinaryOperationNode binaryOp = BinaryOperationNode.create(operator.getOperator(), left, right, operator.getActualSourceCode());
                this.operands.push(binaryOp);
            }
        }
    }

    private static final class OperatorInCode {
        private final BslOperator operator;
        private final ParseTree actualSourceCode;

        public int getPriority() {
            return this.operator.getPriority();
        }

        @ConstructorProperties(value={"operator", "actualSourceCode"})
        @SuppressFBWarnings(justification="generated code")
        @Generated
        public OperatorInCode(BslOperator operator, ParseTree actualSourceCode) {
            this.operator = operator;
            this.actualSourceCode = actualSourceCode;
        }

        @SuppressFBWarnings(justification="generated code")
        @Generated
        public BslOperator getOperator() {
            return this.operator;
        }

        @SuppressFBWarnings(justification="generated code")
        @Generated
        public ParseTree getActualSourceCode() {
            return this.actualSourceCode;
        }

        @SuppressFBWarnings(justification="generated code")
        @Generated
        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof OperatorInCode)) {
                return false;
            }
            OperatorInCode other = (OperatorInCode)o;
            BslOperator this$operator = this.getOperator();
            BslOperator other$operator = other.getOperator();
            if (this$operator == null ? other$operator != null : !((Object)((Object)this$operator)).equals((Object)other$operator)) {
                return false;
            }
            ParseTree this$actualSourceCode = this.getActualSourceCode();
            ParseTree other$actualSourceCode = other.getActualSourceCode();
            return !(this$actualSourceCode == null ? other$actualSourceCode != null : !this$actualSourceCode.equals(other$actualSourceCode));
        }

        @SuppressFBWarnings(justification="generated code")
        @Generated
        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            BslOperator $operator = this.getOperator();
            result = result * 59 + ($operator == null ? 43 : ((Object)((Object)$operator)).hashCode());
            ParseTree $actualSourceCode = this.getActualSourceCode();
            result = result * 59 + ($actualSourceCode == null ? 43 : $actualSourceCode.hashCode());
            return result;
        }

        @SuppressFBWarnings(justification="generated code")
        @Generated
        public String toString() {
            return "ExpressionTreeBuildingVisitor.OperatorInCode(operator=" + this.getOperator() + ", actualSourceCode=" + this.getActualSourceCode() + ")";
        }
    }
}

