# Кеширование программного интерфейса (CachedPublic)

|      Тип      |    Поддерживаются<br>языки    | Важность |    Включена<br>по умолчанию    |    Время на<br>исправление (мин)    |             Теги             |
|:-------------:|:-----------------------------:|:--------:|:------------------------------:|:-----------------------------------:|:----------------------------:|
| `Дефект кода` |             `BSL`             | `Важный` |              `Да`              |                 `5`                 |    `standard`<br>`design`    |

<!-- Блоки выше заполняются автоматически, не трогать -->
## Описание диагностики

Не следует создавать программный интерфейс в модулях с повторным использованием возвращаемых значений.

3.6. Другой пример скрытия деталей реализации библиотеки от потребителя. 
Допустим: в первой версии библиотеки потребителям предоставлялась экспортная функция общего модуля с повторным использованием 
возвращаемых значений; Но в следующей версии библиотеки это проектное решение пересмотрено в пользу 
«обычного» общего модуля, куда эта функция была перенесена (аналогично, если в обратную сторону). В данном примере, 
для того чтобы избавить потребителя библиотеки от дополнительных усилий по замене вызовов «старой» функции на новую,
рекомендуется сразу размещать экспортную функцию в «обычном» модуле, в его разделе «программный интерфейс». Тогда эта
функция, в зависимости от текущего проектного решения, может вызывать служебную функцию из модуля с повторным 
использованием возвращаемых значений или из любого другого модуля, или непосредственно сама содержать реализацию. 
Однако для потребителя ее местоположение уже не будет меняться в следующих версиях библиотеки.

## Примеры
<!-- В данном разделе приводятся примеры, на которые диагностика срабатывает, а также можно привести пример, как можно исправить ситуацию -->

## Источники
<!-- Необходимо указывать ссылки на все источники, из которых почерпнута информация для создания диагностики -->

* Источник: [Стандарт: Обеспечение совместимости библиотек](https://its.1c.ru/db/v8std#content:644:hdoc:3.6)

## Сниппеты

<!-- Блоки ниже заполняются автоматически, не трогать -->
### Экранирование кода

```bsl
// BSLLS:CachedPublic-off
// BSLLS:CachedPublic-on
```

### Параметр конфигурационного файла

```json
"CachedPublic": false
```
