# Определения методов должны размещаться перед операторами тела модуля (CodeBlockBeforeSub)

|   Тип    |    Поддерживаются<br>языки    |   Важность    |    Включена<br>по умолчанию    |    Время на<br>исправление (мин)    |  Теги   |
|:--------:|:-----------------------------:|:-------------:|:------------------------------:|:-----------------------------------:|:-------:|
| `Ошибка` |         `BSL`<br>`OS`         | `Блокирующий` |              `Да`              |                 `5`                 | `error` |

<!-- Блоки выше заполняются автоматически, не трогать -->
## Описание диагностики
<!-- Описание диагностики заполняется вручную. Необходимо понятным языком описать смысл и схему работу -->

Структура программного модуля _(в общем виде)_ четко определена:

- сначала идет блок определения переменных 
- затем определения процедур и функции
- затем блок кода модуля
   
Исходя из описанной выше структуры, расположение программного кода ранее определения методов недопустимо.

## Примеры
<!-- В данном разделе приводятся примеры, на которые диагностика срабатывает, а также можно привести пример, как можно исправить ситуацию -->

Неправильно

```bsl
Метод();
Сообщить("До описания методов");

Процедура Метод()
// Тело методов 
КонецПроцедуры
```

## Источники
<!-- Необходимо указывать ссылки на все источники, из которых почерпнута информация для создания диагностики -->


* [Структура модуля](https://its.1c.ru/db/v8std/content/455/hdoc)

## Сниппеты

<!-- Блоки ниже заполняются автоматически, не трогать -->
### Экранирование кода

```bsl
// BSLLS:CodeBlockBeforeSub-off
// BSLLS:CodeBlockBeforeSub-on
```

### Параметр конфигурационного файла

```json
"CodeBlockBeforeSub": false
```
