# Нерекомендуемое имя общего модуля (CommonModuleNameWords)

|      Тип      |    Поддерживаются<br>языки    |     Важность     |    Включена<br>по умолчанию    |    Время на<br>исправление (мин)    |    Теги    |
|:-------------:|:-----------------------------:|:----------------:|:------------------------------:|:-----------------------------------:|:----------:|
| `Дефект кода` |             `BSL`             | `Информационный` |              `Да`              |                 `5`                 | `standard` |

## Параметры


|   Имя   |   Тип    |        Описание         |                                          Значение<br>по умолчанию                                          |
|:-------:|:--------:|:-----------------------:|:----------------------------------------------------------------------------------------------------------:|
| `words` | `Строка` | `Нерекомендуемые слова` | `процедуры|procedures|функции|functions|обработчики|handlers|модуль|module|функциональность|functionality` |
<!-- Блоки выше заполняются автоматически, не трогать -->
## Описание диагностики
Рекомендуется избегать в названии общего модуля таких общих слов как "Процедуры", "Функции", "Обработчики",
 "Модуль", "Функциональность" и т.п.

## Примеры
<!-- В данном разделе приводятся примеры, на которые диагностика срабатывает, а также можно привести пример, как можно исправить ситуацию -->

## Источники

* Источник: [Стандарт: Правила создания общих модулей](https://its.1c.ru/db/v8std#content:469:hdoc:3.1)

## Сниппеты

<!-- Блоки ниже заполняются автоматически, не трогать -->
### Экранирование кода

```bsl
// BSLLS:CommonModuleNameWords-off
// BSLLS:CommonModuleNameWords-on
```

### Параметр конфигурационного файла

```json
"CommonModuleNameWords": {
    "words": "процедуры|procedures|функции|functions|обработчики|handlers|модуль|module|функциональность|functionality"
}
```
