# Запрет незаполненных значений у измерений регистров (DenyIncompleteValues)

|      Тип      |    Поддерживаются<br>языки    | Важность |    Включена<br>по умолчанию    |    Время на<br>исправление (мин)    |     Теги      |
|:-------------:|:-----------------------------:|:--------:|:------------------------------:|:-----------------------------------:|:-------------:|
| `Дефект кода` |             `BSL`             | `Важный` |             `Нет`              |                 `1`                 | `badpractice` |

<!-- Блоки выше заполняются автоматически, не трогать -->
## Описание диагностики
<!-- Описание диагностики заполняется вручную. Необходимо понятным языком описать смысл и схему работу -->
Довольно часто при проектировании структуры метаданных соблюдается правило - измерения регистра всегда должны быть заполнены конкретными значениями и не должны быть пустыми.

Проверку на заполненность измерений удобно выполнять с помощью простых встроенных средств платформы, а именно, флага "Запрет незаполненных значений" для измерения регистра. В этом случае платформа самостоятельно будет проверять заполненность измерений и не нужно дополнительно контролировать заполнение измерения ни при программной обработке регистров, ни при интерактивной обработке.
Фактически записи с незаполненным измерением не имеют смысла в информационной базе, каким бы образом они в нее ни попали: в результате интерактивного ввода или в результате выполнения программного кода.

Без установки указанного флага могут возникать различные ситуации, которые приводят к проблемам или усложняют сопровождение систем 1С. Например,
- пользователи смогут интерактивно указать пустые значения
- или разработчики могут при разработке ошибаться, не указывая значения измерения при подготовке записей регистра.

Текущее правило может выдавать ложные срабатывания для измерений, которые могут быть не заполнены.

Правило применяется для следующих регистров:
- сведений
- накопления
- бухгалтерских
- расчетных

## Примеры
<!-- В данном разделе приводятся примеры, на которые диагностика срабатывает, а также можно привести пример, как можно исправить ситуацию -->

## Источники
<!-- Необходимо указывать ссылки на все источники, из которых почерпнута информация для создания диагностики -->
<!-- Примеры источников

* Источник: [Стандарт: Тексты модулей](https://its.1c.ru/db/v8std#content:456:hdoc)
* Полезная информация: [Отказ от использования модальных окон](https://its.1c.ru/db/metod8dev#content:5272:hdoc)
* Источник: [Cognitive complexity, ver. 1.4](https://www.sonarsource.com/docs/CognitiveComplexity.pdf) -->
- [Книга "Разработка интерфейса прикладных решений на платформе "1С:Предприятие 8" - глава "Проверка заполнения и проверка при записи"](https://its.1c.ru/db/pubv8devui#content:225:1)
- [Документация разработчика 1С 8.3 - Свойства измерения (ресурса, реквизита) регистра сведений](https://its.1c.ru/db/v8323doc#bookmark:dev:TI000000349)
- [Документация разработчика 1С 8.3 - Свойства измерения (ресурса, реквизита) регистра накопления](https://its.1c.ru/db/v8323doc#bookmark:dev:TI000000363)

## Сниппеты

<!-- Блоки ниже заполняются автоматически, не трогать -->
### Экранирование кода

```bsl
// BSLLS:DenyIncompleteValues-off
// BSLLS:DenyIncompleteValues-on
```

### Параметр конфигурационного файла

```json
"DenyIncompleteValues": false
```
