# Функция всегда возвращает одно и то же примитивное значение (FunctionReturnsSamePrimitive)

|   Тип    |    Поддерживаются<br>языки    | Важность |    Включена<br>по умолчанию    |    Время на<br>исправление (мин)    |              Теги               |
|:--------:|:-----------------------------:|:--------:|:------------------------------:|:-----------------------------------:|:-------------------------------:|
| `Ошибка` |         `BSL`<br>`OS`         | `Важный` |              `Да`              |                 `5`                 |    `design`<br>`badpractice`    |

## Параметры


|           Имя            |   Тип    |                 Описание                  |    Значение<br>по умолчанию    |
|:------------------------:|:--------:|:-----------------------------------------:|:------------------------------:|
|     `skipAttachable`     | `Булево` |    `Не учитывать подключаемые методы`     |             `true`             |
| `caseSensitiveForString` | `Булево` | `Учитывать регистр в строковых значениях` |            `false`             |
<!-- Блоки выше заполняются автоматически, не трогать -->
## Описание диагностики
<!-- Описание диагностики заполняется вручную. Необходимо понятным языком описать смысл и схему работу -->

Функция не должна возвращать одно и тоже примитивное значение. Если результат функции не учитывается - то нужно функцию 
переписать на процедуру.

## Примеры
<!-- В данном разделе приводятся примеры, на которые диагностика срабатывает, а также можно привести пример, как можно исправить ситуацию -->

Плохо:
```bsl
Функция ПроверитьСтроку(Знач СтрокаТаблицы)

    Если ЭтоХорошаяСтрока(СтрокаТаблицы) Тогда
        ДелаемЧтоТоЧтобыНеРугаласьПроверкаНаПовтор();
        Возврат Истина;
    ИначеЕсли ЭтоТожеНеплохаяСтрока(СтрокаТаблицы) Тогда
        ДелаемДругоеЧтоТоЧтобыНеРугаласьПроверкаНаПовтор();
        Возврат Истина;
     Иначе
        Возврат Истина;
    КонецЕсли;

КонецФункции
```

Хорошо:
```bsl
Процедура ПроверитьСтроку(Знач СтрокаТаблицы)

    Если ЭтоХорошаяСтрока(СтрокаТаблицы) Тогда
        ДелаемЧтоТоЧтобыНеРугаласьПроверкаНаПовтор();
    ИначеЕсли ЭтоТожеНеплохаяСтрока(СтрокаТаблицы) Тогда
        ДелаемДругоеЧтоТоЧтобыНеРугаласьПроверкаНаПовтор();
    Иначе
        ДелаемЧтотоДругоеИзВеткиИначе();
    КонецЕсли;

КонецПроцедуры
```

## Особенности

Из проверки исключаются подключаемые Функции. Например:
```bsl
Функция Подключаемый_КакаяТоКоманда(Команда)

    Если ЗначениеЗаполнено(ТекущаяДата) Тогда
        Возврат Неопределено;
    КонецЕсли;

    Возврат Неопределено;

КонецФункции
```

## Источники
<!-- Необходимо указывать ссылки на все источники, из которых почерпнута информация для создания диагностики -->

## Сниппеты

<!-- Блоки ниже заполняются автоматически, не трогать -->
### Экранирование кода

```bsl
// BSLLS:FunctionReturnsSamePrimitive-off
// BSLLS:FunctionReturnsSamePrimitive-on
```

### Параметр конфигурационного файла

```json
"FunctionReturnsSamePrimitive": {
    "skipAttachable": true,
    "caseSensitiveForString": false
}
```
