# Одинаковые выражения слева и справа от "foo" оператора (IdenticalExpressions)

|   Тип    |    Поддерживаются<br>языки    | Важность |    Включена<br>по умолчанию    |    Время на<br>исправление (мин)    |     Теги     |
|:--------:|:-----------------------------:|:--------:|:------------------------------:|:-----------------------------------:|:------------:|
| `Ошибка` |         `BSL`<br>`OS`         | `Важный` |              `Да`              |                 `5`                 | `suspicious` |

## Параметры


|        Имя        |   Тип    |                                                                                                              Описание                                                                                                              |    Значение<br>по умолчанию    |
|:-----------------:|:--------:|:----------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------:|:------------------------------:|
| `popularDivisors` | `Строка` | `Существуют популярные операции деления на константы, например, 60 или 1024 для масштабирования значений времени и/или байтов. Укажите через запятую числа, которые не нужно считать ошибкой повтора операнда в операции деления.` |           `60, 1024`           |
<!-- Блоки выше заполняются автоматически, не трогать -->
## Описание диагностики

Если в тексте программы имеется оператор (<, >, <=, >=, =, <>, И, ИЛИ, -, /), слева и справа от которого расположены одинаковые подвыражения фрагмент кода, который, скорее всего, содержит логическую ошибку.

## Примеры

```bsl
Если Сумма <> 0 И Сумма <> 0 Тогда

    // Тут код

КонецЕсли;
```

Здесь оператор `И` окружен одинаковыми выражениями `Сумма <> 0`,
что наталкивает на мысли об ошибке по невнимательности при копировании. Правильное выражение будет выглядеть так:

```bsl
Если Сумма <> 0 И СуммаНДС <> 0 Тогда

    // Тут код

КонецЕсли;
```

ИЛИ

```bsl
Если Сумма <> 0 Тогда

    // Тут код

КонецЕсли;
```

## Сниппеты

<!-- Блоки ниже заполняются автоматически, не трогать -->
### Экранирование кода

```bsl
// BSLLS:IdenticalExpressions-off
// BSLLS:IdenticalExpressions-on
```

### Параметр конфигурационного файла

```json
"IdenticalExpressions": {
    "popularDivisors": "60, 1024"
}
```
