# Неверное использование "СтрШаблон" (IncorrectUseOfStrTemplate)

|   Тип    |    Поддерживаются<br>языки    |   Важность    |    Включена<br>по умолчанию    |    Время на<br>исправление (мин)    |                              Теги                              |
|:--------:|:-----------------------------:|:-------------:|:------------------------------:|:-----------------------------------:|:--------------------------------------------------------------:|
| `Ошибка` |         `BSL`<br>`OS`         | `Блокирующий` |              `Да`              |                 `1`                 |       `brainoverload`<br>`suspicious`<br>`unpredictable`       |

<!-- Блоки выше заполняются автоматически, не трогать -->
## Описание диагностики
<!-- Описание диагностики заполняется вручную. Необходимо понятным языком описать смысл и схему работу -->
При использовании метода `СтрШаблон` нужно внимательно составлять шаблонную строку и передавать правильное количество параметров.
И можно довольно легко ошибиться при передаче значений для `СтрШаблон`.

Важно помнить, что 
- `СтрШаблон` принимает только параметры от `%1` до `%10`
- если требуется передать сразу после шаблона число, нужно добавить скобки - `"%(1)45"`

## Примеры
<!-- В данном разделе приводятся примеры, на которые диагностика срабатывает, а также можно привести пример, как можно исправить ситуацию -->

Вариант 1 - количество переданных после шаблонной строки значений не равно (меньше или больше) максимальному номеру из строки вида %N внутри шаблонной строки
 
  - `СтрШаблон("Наименование (версия %1)"); // не передан необходимый параметр для %1`
  - `СтрШаблон("%1 (версия %2)", Наименование); // не передан необходимый параметр для %2`

Вариант 2 - не передается вообще никаких значений, кроме форматированной строки из-за большого количества скобок внутри несложного выражения с `НСтр` и `СтрШаблон`:

  - `СтрШаблон(НСтр("ru='Наименование (версия %1)'", Версия()));`

Здесь ошибочно не закрыта скобка для `НСтр`. В итоге выражение после вычисления `НСтр` становится пустым.
Выявить подобную ошибку чтением кода довольно сложно из-за наличия скобок. И можно поймать только в рантайме, получив исключение.

Правильный вариант 
  - `СтрШаблон(НСтр("ru='Наименование (версия %1)'"), Версия());`

Вариант 3 - правильный пример передачи цифр сразу после шаблонного значения
  - `СтрШаблон("Наименование %(1)2"), Наименование); // если передать значение "МояСтрока", то результат будет "МояСтрока2"`

## Источники
<!-- Необходимо указывать ссылки на все источники, из которых почерпнута информация для создания диагностики -->
<!-- Примеры источников

* Источник: [Стандарт: Тексты модулей](https://its.1c.ru/db/v8std#content:456:hdoc)
* Полезная информация: [Отказ от использования модальных окон](https://its.1c.ru/db/metod8dev#content:5272:hdoc)
* Источник: [Cognitive complexity, ver. 1.4](https://www.sonarsource.com/docs/CognitiveComplexity.pdf) -->

- [Требования по локализации - Стандарт](https://its.1c.ru/db/v8std/content/763/hdoc)

## Сниппеты

<!-- Блоки ниже заполняются автоматически, не трогать -->
### Экранирование кода

```bsl
// BSLLS:IncorrectUseOfStrTemplate-off
// BSLLS:IncorrectUseOfStrTemplate-on
```

### Параметр конфигурационного файла

```json
"IncorrectUseOfStrTemplate": false
```
