# Соединение с вложенными запросами (JoinWithSubQuery)

|      Тип      |    Поддерживаются<br>языки    | Важность |    Включена<br>по умолчанию    |    Время на<br>исправление (мин)    |                       Теги                       |
|:-------------:|:-----------------------------:|:--------:|:------------------------------:|:-----------------------------------:|:------------------------------------------------:|
| `Дефект кода` |             `BSL`             | `Важный` |              `Да`              |                `10`                 |       `sql`<br>`standard`<br>`performance`       |

<!-- Блоки выше заполняются автоматически, не трогать -->
## Описание диагностики
<!-- Описание диагностики заполняется вручную. Необходимо понятным языком описать смысл и схему работу -->

При написании запросов не следует использовать соединения с вложенными запросами. Следует соединять друг с другом только объекты метаданных или временные таблицы.  

Если запрос содержит соединения с вложенными запросами, то это может привести к следующим негативным последствиям:

- Крайне медленное выполнение запроса при слабой загрузке серверного оборудования
- Нестабильная работа запроса. При некоторых условиях запрос может работать достаточно быстро, при других - очень медленно
- Значительная разница по времени выполнения запроса на разных СУБД
- Повышенная чувствительность запроса к актуальности и полноте статистик. Сразу после полного обновления статистик запрос может работать быстро, но через некоторое время опять замедлиться

## Примеры
<!-- В данном разделе приводятся примеры, на которые диагностика срабатывает, а также можно привести пример, как можно исправить ситуацию -->

Пример потенциально опасного запроса, использующего соединение с вложенным запросом:

```bsl
ВЫБРАТЬ *
ИЗ Документ.РеализацияТоваровУслуг
ЛЕВОЕ СОЕДИНЕНИЕ (
   ВЫБРАТЬ Измерение1 ИЗ РегистрСведений.Лимиты
   ГДЕ Поле В (&СписокЗначений) 
   СГРУППИРОВАТЬ ПО 
   Измерение1
) ПО Ссылка = Измерение1
```

## Источники
<!-- Необходимо указывать ссылки на все источники, из которых почерпнута информация для создания диагностики -->
<!-- Примеры источников

* Источник: [Стандарт: Тексты модулей](https://its.1c.ru/db/v8std#content:456:hdoc)
* Полезная информация: [Отказ от использования модальных окон](https://its.1c.ru/db/metod8dev#content:5272:hdoc)
* Источник: [Cognitive complexity, ver. 1.4](https://www.sonarsource.com/docs/CognitiveComplexity.pdf) -->

* [Стандарт: Ограничения на соединения с вложенными запросами и виртуальными таблицами](https://its.1c.ru/db/v8std#content:655:hdoc)

## Сниппеты

<!-- Блоки ниже заполняются автоматически, не трогать -->
### Экранирование кода

```bsl
// BSLLS:JoinWithSubQuery-off
// BSLLS:JoinWithSubQuery-on
```

### Параметр конфигурационного файла

```json
"JoinWithSubQuery": false
```
