# Пропущены пробелы слева или справа от операторов `+ - * / = % < > <> <= >=`, от ключевых слов, а так же справа от `,` и `;` (MissingSpace)

|      Тип      |    Поддерживаются<br>языки    |     Важность     |    Включена<br>по умолчанию    |    Время на<br>исправление (мин)    |     Теги      |
|:-------------:|:-----------------------------:|:----------------:|:------------------------------:|:-----------------------------------:|:-------------:|
| `Дефект кода` |         `BSL`<br>`OS`         | `Информационный` |              `Да`              |                 `1`                 | `badpractice` |

## Параметры


|            Имя             |   Тип    |                                        Описание                                        |    Значение<br>по умолчанию    |
|:--------------------------:|:--------:|:--------------------------------------------------------------------------------------:|:------------------------------:|
|     `listForCheckLeft`     | `Строка` |           `Список для проверки слева (разделенные пробелом). Например: ) =`            |               ``               |
|    `listForCheckRight`     | `Строка` |           `Список для проверки справа (разделенные пробелом). Например: ( =`           |             `, ;`              |
| `listForCheckLeftAndRight` | `Строка` | `Список для проверки с обоих сторон (разделенные пробелом). Например: + - * / = % < >` |   `+ - * / = % < > <> <= >=`   |
| `checkSpaceToRightOfUnary` | `Булево` |               `Проверять наличие пробела справа от унарных знаков (+ -)`               |            `false`             |
|   `allowMultipleCommas`    | `Булево` |                          `Разрешать несколько запятых подряд`                          |            `false`             |
<!-- Блоки выше заполняются автоматически, не трогать -->
## Описание диагностики

Для улучшения читаемости кода слева и справа от операторов `+ - * / = % < > <> <= >=` должны быть пробелы.
Так же пробел должен быть справа от `,` и `;`

## Примеры

Плохо

```bsl
Процедура ВычислитьСумму(Параметр1,Параметр2)
    Если Параметр1=Параметр2 Тогда
        Сумма=Цена*Количество;
    КонецЕсли;
КонецПроцедуры
```

Хорошо

```bsl
Процедура ВычислитьСумму(Параметр1, Параметр2)
    Если Параметр1 = Параметр2 Тогда
        Сумма = Цена * Количество;
    КонецЕсли;
КонецПроцедуры
```

### Использование параметра `checkSpaceToRightOfUnary`

Параметр имеет смысл, только если унарный оператор присутствует в одном из трех основных параметров.

При значении `false` 

```bsl
А = -Б;     // Хорошо
А = - Б;    // Хорошо
```

При значении `true`

```bsl
А = -Б;     // Плохо
А = - Б;    // Хорошо
```

### Использование параметра `allowMultipleCommas`

Параметр имеет смысл, только если `,` присутствует в одном из трех основных параметров. Значение по-умолчанию `false`

При значении `false`

```bsl
    ОбщегоНазначенияКлиентСервер.СообщитьПользователю(ТекстСообщения,,,, Отказ);        // Плохо
    ОбщегоНазначенияКлиентСервер.СообщитьПользователю(ТекстСообщения, , , , Отказ);     // Хорошо
```

При значении `true`

```bsl
    ОбщегоНазначенияКлиентСервер.СообщитьПользователю(ТекстСообщения,,,, Отказ);        // Хорошо
    ОбщегоНазначенияКлиентСервер.СообщитьПользователю(ТекстСообщения, , , , Отказ);     // Хорошо
```

## Сниппеты

<!-- Блоки ниже заполняются автоматически, не трогать -->
### Экранирование кода

```bsl
// BSLLS:MissingSpace-off
// BSLLS:MissingSpace-on
```

### Параметр конфигурационного файла

```json
"MissingSpace": {
    "listForCheckLeft": "",
    "listForCheckRight": ", ;",
    "listForCheckLeftAndRight": "+ - * / = % < > <> <= >=",
    "checkSpaceToRightOfUnary": false,
    "allowMultipleCommas": false
}
```
