# Вложенный тернарный оператор (NestedTernaryOperator)

|      Тип      |    Поддерживаются<br>языки    | Важность |    Включена<br>по умолчанию    |    Время на<br>исправление (мин)    |      Теги       |
|:-------------:|:-----------------------------:|:--------:|:------------------------------:|:-----------------------------------:|:---------------:|
| `Дефект кода` |         `BSL`<br>`OS`         | `Важный` |              `Да`              |                 `5`                 | `brainoverload` |

<!-- Блоки выше заполняются автоматически, не трогать -->
## Описание диагностики

Использование вложенных тернарных операторов затрудняет читаемость кода.

## Примеры

### Некорректное использование тернарных операторов

```bsl
Результат  =  ?(x % 15 <> 0, ?( x % 5 <> 0, ?( x % 3 <> 0, x, "Fizz"), "Buzz"), "FizzBuzz"); 
```

```bsl
Если ?(Стр.Emp_emptype = Null, 0, Стр.Emp_emptype) = 0 Тогда

      Статус = "Готово";

КонецЕсли;
```

### Возможные вариант реализации

```bsl
Если x % 15 = 0 Тогда
	Результат = "FizzBuzz";
ИначеЕсли x % 3 = 0 Тогда
	Результат = "Fizz";
ИначеЕсли x % 5 = 0 Тогда
	Результат = "Buzz";
Иначе
	Результат = x;
КонецЕсли;
```

```bsl
Если Стр.Emp_emptype = Null ИЛИ Стр.Emp_emptype = 0 Тогда

      Статус = "Готово";

КонецЕсли;
```

## Сниппеты

<!-- Блоки ниже заполняются автоматически, не трогать -->
### Экранирование кода

```bsl
// BSLLS:NestedTernaryOperator-off
// BSLLS:NestedTernaryOperator-on
```

### Параметр конфигурационного файла

```json
"NestedTernaryOperator": false
```
