# Ограничение на количество значений свойств, передаваемых в конструктор структуры (NumberOfValuesInStructureConstructor)

|      Тип      |    Поддерживаются<br>языки    |     Важность     |    Включена<br>по умолчанию    |    Время на<br>исправление (мин)    |                Теги                 |
|:-------------:|:-----------------------------:|:----------------:|:------------------------------:|:-----------------------------------:|:-----------------------------------:|
| `Дефект кода` |         `BSL`<br>`OS`         | `Незначительный` |              `Да`              |                `10`                 |    `standard`<br>`brainoverload`    |

## Параметры


|       Имя        |   Тип   |                                    Описание                                    |    Значение<br>по умолчанию    |
|:----------------:|:-------:|:------------------------------------------------------------------------------:|:------------------------------:|
| `maxValuesCount` | `Целое` | `Допустимое количество значений свойств, передаваемых в конструктор структуры` |              `3`               |
<!-- Блоки выше заполняются автоматически, не трогать -->
## Описание диагностики

При создании объекта типа Структура не рекомендуется передавать в конструктор более 3-х значений свойств.
Вместо этого рекомендуется использовать метод Вставить или присваивать значения свойствам явным образом

## Примеры

Неправильно:

```bsl
ПараметрыФормыКомпоновки  = Новый Структура(
   "НеПомещатьНастройкиВСхемуКомпоновкиДанных,
   |НеРедактироватьСхемуКомпоновкиДанных,
   |НеНастраиватьУсловноеОформление,
   |НеНастраиватьВыбор,
   |НеНастраиватьПорядок,
   |АдресСхемыКомпоновкиДанных,
   |АдресНастроекКомпоновкиДанных,
   |УникальныйИдентификатор,
   |Заголовок",
   Истина,
   Истина,
   Истина,
   Истина,
   Истина,
   ТекущиеДанные.АдресСхемыКомпоновкиДанных,
   ?(АдресНастроекСхемыКомпоновкиДанных <> Неопределено,
        АдресНастроекСхемыКомпоновкиДанных,
        ТекущиеДанные.АдресНастроекСхемыКомпоновкиДанных),
   УникальныйИдентификатор,
   ЗаголовокФормыНастройкиСхемыКомпоновкиДанных));
```

Правильно:

```bsl
ПараметрыФормыКомпоновки  = Новый Структура;

ПараметрыФормыКомпоновки.Вставить("НеПомещатьНастройкиВСхемуКомпоновкиДанных", Истина);
ПараметрыФормыКомпоновки.Вставить("НеРедактироватьСхемуКомпоновкиДанных", Истина);
ПараметрыФормыКомпоновки.Вставить("НеРедактироватьСхемуКомпоновкиДанных", Истина);
ПараметрыФормыКомпоновки.Вставить("НеНастраиватьВыбор", Истина);
ПараметрыФормыКомпоновки.Вставить("НеНастраиватьПорядок", Истина);
ПараметрыФормыКомпоновки.Вставить("АдресСхемыКомпоновкиДанных", ТекущиеДанные.АдресСхемыКомпоновкиДанных);
ПараметрыФормыКомпоновки.Вставить("АдресНастроекКомпоновкиДанных", ?(АдресНастроекСхемыКомпоновкиДанных <> Неопределено,
                                                                                                                         АдресНастроекСхемыКомпоновкиДанных,
                                                                                                                         ТекущиеДанные.АдресНастроекСхемыКомпоновкиДанных));
ПараметрыФормыКомпоновки.Вставить("УникальныйИдентификатор ", УникальныйИдентификатор);
ПараметрыФормыКомпоновки.Вставить("Заголовок", ЗаголовокФормыНастройкиСхемыКомпоновкиДанных);
```

## Источники

* [Стандарт: Использование объектов типа Структура](https://its.1c.ru/db/v8std#content:693:hdoc)

## Сниппеты

<!-- Блоки ниже заполняются автоматически, не трогать -->
### Экранирование кода

```bsl
// BSLLS:NumberOfValuesInStructureConstructor-off
// BSLLS:NumberOfValuesInStructureConstructor-on
```

### Параметр конфигурационного файла

```json
"NumberOfValuesInStructureConstructor": {
    "maxValuesCount": 3
}
```
