# Совпадает имя объекта метаданного и его дочернего (SameMetadataObjectAndChildNames)

|   Тип    |    Поддерживаются<br>языки    |  Важность   |    Включена<br>по умолчанию    |    Время на<br>исправление (мин)    |                    Теги                     |
|:--------:|:-----------------------------:|:-----------:|:------------------------------:|:-----------------------------------:|:-------------------------------------------:|
| `Ошибка` |             `BSL`             | `Критичный` |              `Да`              |                `30`                 |       `standard`<br>`sql`<br>`design`       |

<!-- Блоки выше заполняются автоматически, не трогать -->
## Описание диагностики
<!-- Описание диагностики заполняется вручную. Необходимо понятным языком описать смысл и схему работу -->

Для подчиненных объектов метаданных, таких как реквизиты, измерения, ресурсы, табличные части (и их реквизиты) не рекомендуется использовать имена, совпадающие с именами объектов-владельцев, т.к. это может приводить к ошибкам в запросах. 

## Примеры
<!-- В данном разделе приводятся примеры, на которые диагностика срабатывает, а также можно привести пример, как можно исправить ситуацию -->

Неправильное именование

```
Справочник.Контрагенты.ТабличнаяЧасть.Контрагенты
РегистрСведений.ПодчиненныеДокументы.Измерение.ПодчиненныеДокументы
Документ.Тара.ТабличнаяЧасть.Тара.Реквизит.Тара
```

## Источники
<!-- Необходимо указывать ссылки на все источники, из которых почерпнута информация для создания диагностики -->
<!-- Примеры источников

* Источник: [Стандарт: Тексты модулей](https://its.1c.ru/db/v8std#content:456:hdoc)
* Полезная информация: [Отказ от использования модальных окон](https://its.1c.ru/db/metod8dev#content:5272:hdoc)
* Источник: [Cognitive complexity, ver. 1.4](https://www.sonarsource.com/docs/CognitiveComplexity.pdf) -->

* [Стандарт: Организация хранения данных. Имя, Синоним, Комментарий](https://its.1c.ru/db/v8std#content:474:hdoc:2.4)

## Сниппеты

<!-- Блоки ниже заполняются автоматически, не трогать -->
### Экранирование кода

```bsl
// BSLLS:SameMetadataObjectAndChildNames-off
// BSLLS:SameMetadataObjectAndChildNames-on
```

### Параметр конфигурационного файла

```json
"SameMetadataObjectAndChildNames": false
```
