# Вызов функции КаталогВременныхФайлов() (TempFilesDir)

|      Тип      |    Поддерживаются<br>языки    | Важность |    Включена<br>по умолчанию    |    Время на<br>исправление (мин)    |               Теги                |
|:-------------:|:-----------------------------:|:--------:|:------------------------------:|:-----------------------------------:|:---------------------------------:|
| `Дефект кода` |             `BSL`             | `Важный` |              `Да`              |                 `5`                 |    `standard`<br>`badpractice`    |

<!-- Блоки выше заполняются автоматически, не трогать -->
## Описание диагностики
<!-- Описание диагностики заполняется вручную. Необходимо понятным языком описать смысл и схему работу -->
При использовании метода ПолучитьИмяВременногоФайла() платформа 1С:Предприятие сохраняет контроль над такими файлами 
и автоматически удаляет их при перезапуске рабочего процесса (если файл был создан на стороне сервера) или клиентского приложения (если файл был создан на стороне клиента).

Если же имя временного файла было сформировано каким-то другим способом, и прикладной код не удалил (либо по какой-то причине не смог удалить) ранее созданный
  временный файл, то платформа такой файл не контролирует, и он остается в файловой системе на неопределенное время. 
  Накапливание «потерянных» временных файлов может представлять серьезную проблему, особенно для информационных баз
  с большим количеством активно работающих пользователей (например, при работе в режиме сервиса).
## Примеры
<!-- В данном разделе приводятся примеры, на которые диагностика срабатывает, а также можно привести пример, как можно исправить ситуацию -->

Неправильно:

```bsl
Каталог = КаталогВременныхФайлов();
ИмяФайла = Строка(Новый УникальныйИдентификатор) + ".xml";
ИмяПромежуточногоФайла = Каталог + ИмяФайла;
Данные.Записать(ИмяПромежуточногоФайла);
```

Правильно:

```bsl
ИмяПромежуточногоФайла = ПолучитьИмяВременногоФайла("xml");
Данные.Записать(ИмяПромежуточногоФайла);
```

Для создания временного каталога рекомендуется также использовать имя, полученное при помощи метода ПолучитьИмяВременногоФайла (исключение составляет веб-клиент).

Неправильно:

```bsl
Архив = Новый ЧтениеZipФайла(ИмяФайлаАрхива); 
КаталогАрхива = КаталогВременныхФайлов()+"main_zip\";
СоздатьКаталог(КаталогАрхива);
Архив.ИзвлечьВсе(КаталогАрхива);
```

Правильно:

```bsl
Архив = Новый ЧтениеZipФайла(ИмяФайлаАрхива); 
КаталогАрхива = ПолучитьИмяВременногоФайла() + "\main_zip\";
СоздатьКаталог(КаталогАрхива);
Архив.ИзвлечьВсе(КаталогАрхива);
```

## Источники

* Источник: [Стандарт: Доступ к файловой системе из кода конфигурации](https://its.1c.ru/db/v8std#content:542:hdoc)

## Сниппеты

<!-- Блоки ниже заполняются автоматически, не трогать -->
### Экранирование кода

```bsl
// BSLLS:TempFilesDir-off
// BSLLS:TempFilesDir-on
```

### Параметр конфигурационного файла

```json
"TempFilesDir": false
```
