# Работа с параметром "Отказ" (UsingCancelParameter)

|      Тип      |    Поддерживаются<br>языки    | Важность |    Включена<br>по умолчанию    |    Время на<br>исправление (мин)    |               Теги                |
|:-------------:|:-----------------------------:|:--------:|:------------------------------:|:-----------------------------------:|:---------------------------------:|
| `Дефект кода` |         `BSL`<br>`OS`         | `Важный` |              `Да`              |                `10`                 |    `standard`<br>`badpractice`    |

<!-- Блоки выше заполняются автоматически, не трогать -->
## Описание диагностики

В обработчиках событий модулей объектов, наборов записей, форм и т.п., содержащих параметр Отказ (ПриЗаписи, ОбработкаПроверкиЗаполнения, ТоварыПередНачаломДобавления и т.п.), не следует присваивать этому параметру значение Ложь.  
Это требование обусловлено тем, что, как правило, в коде обработчиков событий параметр Отказ может устанавливаться сразу в нескольких последовательных проверках (или в нескольких подписках на одно и то же событие). В таком случае к моменту выполнения очередной проверки параметр Отказ уже может заранее содержать значение Истина, и можно ошибочно сбросить его обратно в Ложь.  
Кроме того, при доработках конфигурации на внедрении число этих проверок может увеличиться.

## Примеры

### Неправильно

```bsl
Процедура ОбработкаПроверкиЗаполнения(Отказ, ПроверяемыеРеквизиты)
  ...
  Отказ = ЕстьОшибкиЗаполнения();
  ...
КонецПроцедуры
```

### Правильно

```bsl
Процедура ОбработкаПроверкиЗаполнения(Отказ, ПроверяемыеРеквизиты)
  ...
  Если ЕстьОшибкиЗаполнения() Тогда
   Отказ = Истина;
  КонецЕсли;
  ...
КонецПроцедуры
```

или

```bsl
Отказ = Отказ Или ЕстьОшибкиЗаполнения();
```

## Источники

* [Работа с параметром "Отказ" в обработчиках событий](https://its.1c.ru/db/v8std#content:686:hdoc)

## Сниппеты

<!-- Блоки ниже заполняются автоматически, не трогать -->
### Экранирование кода

```bsl
// BSLLS:UsingCancelParameter-off
// BSLLS:UsingCancelParameter-on
```

### Параметр конфигурационного файла

```json
"UsingCancelParameter": false
```
