# Хранение путей к файлам в коде (UsingHardcodePath)

|   Тип    |    Поддерживаются<br>языки    |  Важность   |    Включена<br>по умолчанию    |    Время на<br>исправление (мин)    |    Теги    |
|:--------:|:-----------------------------:|:-----------:|:------------------------------:|:-----------------------------------:|:----------:|
| `Ошибка` |             `BSL`             | `Критичный` |              `Да`              |                `15`                 | `standard` |

## Параметры


|            Имя            |   Тип    |                          Описание                           |                                 Значение<br>по умолчанию                                  |
|:-------------------------:|:--------:|:-----------------------------------------------------------:|:-----------------------------------------------------------------------------------------:|
| `searchWordsStdPathsUnix` | `Строка` | `Ключевые слова поиска стандартных корневых каталогов Unix` | `bin|boot|dev|etc|home|lib|lost\+found|misc|mnt|media|opt|proc|root|run|sbin|tmp|usr|var` |
<!-- Блоки выше заполняются автоматически, не трогать -->
## Описание диагностики

Запрещено хранить в коде:

* Пути к файлам и папкам (Windows, Unix)

Есть как минимум несколько способов правильного хранения такой информации:

* Хранение в константе.
* Хранение в регистре сведений.
* Хранение в отдельном модулей, в котором отключена проверка правила (не рекомендуется).
* Хранение в справочнике, узле плана обмена и т.д..

### Особенности

При поиске путей Windows / Unix происходит проверка и на URL в строке. Ключевые слова поиска URL:
* ``http``
* ``https``
* ``ftp``

## Примеры

Неправильно:

```bsl
КаталогОбмена = "c:/обмен/обменданными";
```

Правильно:

```bsl
КаталогОбмена = Константы.КаталогОбмена.Получить();
```

или

```bsl
КаталогОбмена = ОбменДаннымиПовтИсп.КаталогОбмена();
```

## Сниппеты

<!-- Блоки ниже заполняются автоматически, не трогать -->
### Экранирование кода

```bsl
// BSLLS:UsingHardcodePath-off
// BSLLS:UsingHardcodePath-on
```

### Параметр конфигурационного файла

```json
"UsingHardcodePath": {
    "searchWordsStdPathsUnix": "bin|boot|dev|etc|home|lib|lost\\+found|misc|mnt|media|opt|proc|root|run|sbin|tmp|usr|var"
}
```
