# Хранение конфиденциальной информации в коде (UsingHardcodeSecretInformation)

|     Тип      |    Поддерживаются<br>языки    |  Важность   |    Включена<br>по умолчанию    |    Время на<br>исправление (мин)    |    Теги    |
|:------------:|:-----------------------------:|:-----------:|:------------------------------:|:-----------------------------------:|:----------:|
| `Уязвимость` |             `BSL`             | `Критичный` |              `Да`              |                `15`                 | `standard` |

## Параметры


|      Имя      |   Тип    |                                           Описание                                           |    Значение<br>по умолчанию    |
|:-------------:|:--------:|:--------------------------------------------------------------------------------------------:|:------------------------------:|
| `searchWords` | `Строка` | `Ключевые слова поиска конфиденциальной информации в переменных, структурах, соответствиях.` |       `Пароль|Password`        |
<!-- Блоки выше заполняются автоматически, не трогать -->
## Описание диагностики

Запрещено хранить конфиденциальную информацию в коде. Список конфиденциальной информации:

* Пароли
* Персональные ключи доступа

Если в проекте 1С используется подсистема БСП, то хранение паролей можно организовать через безопасное хранилище.

### Дополнительно

В значений паролей исключаются строки, где все символы `*`:

```bsl
Пароль = "**********";
```

## Примеры

Неправильно:

```bsl
Пароль = "12345";
```

Правильно:

```bsl
Пароли = ОбщегоНазначения.ПрочитатьДанныеИзБезопасногоХранилища("ИдентификаторХранения", "Пароль");
Пароль = Пароли.Пароль;
```

## Источники

* [Стандарт: Безопасное хранение паролей](https://its.1c.ru/db/v8std#content:740:hdoc)

## Сниппеты

<!-- Блоки ниже заполняются автоматически, не трогать -->
### Экранирование кода

```bsl
// BSLLS:UsingHardcodeSecretInformation-off
// BSLLS:UsingHardcodeSecretInformation-on
```

### Параметр конфигурационного файла

```json
"UsingHardcodeSecretInformation": {
    "searchWords": "Пароль|Password"
}
```
