# Использование модальных окон (UsingModalWindows)

|      Тип      |    Поддерживаются<br>языки    | Важность |    Включена<br>по умолчанию    |    Время на<br>исправление (мин)    |    Теги    |
|:-------------:|:-----------------------------:|:--------:|:------------------------------:|:-----------------------------------:|:----------:|
| `Дефект кода` |             `BSL`             | `Важный` |              `Да`              |                `15`                 | `standard` |

## Параметры


|         Имя         |   Тип    |                       Описание                        |    Значение<br>по умолчанию    |
|:-------------------:|:--------:|:-----------------------------------------------------:|:------------------------------:|
| `forceModalityMode` | `Булево` | `Игнорировать использование модальности конфигурации` |            `false`             |
<!-- Блоки выше заполняются автоматически, не трогать -->
## Описание диагностики

Модальные и всплывающие окна считаются плохим тоном, пользователи привыкли к работе "в одном окне". При разработке конфигураций, предназначенных для работы в веб-клиенте, запрещено использовать модальные формы и диалоги. В противном случае, конфигурация окажется неработоспособной в ряде веб-браузеров, так как модальные окна не входят в стандарт веб-разработки.

### Ограничения диагностики

На данный момент диагностируется **только использование методов глобального контекста**.

Список методов:

|Метод|Английский вариант|
| :-- | :-- |
|ВОПРОС|DOQUERYBOX|
|ОТКРЫТЬФОРМУМОДАЛЬНО|OPENFORMMODAL|
|ОТКРЫТЬЗНАЧЕНИЕ|OPENVALUE|
|ПРЕДУПРЕЖДЕНИЕ|DOMESSAGEBOX|
|ВВЕСТИДАТУ|INPUTDATE|
|ВВЕСТИЗНАЧЕНИЕ|INPUTVALUE|
|ВВЕСТИСТРОКУ|INPUTSTRING|
|ВВЕСТИЧИСЛО|INPUTNUMBER|
|УСТАНОВИТЬВНЕШНЮЮКОМПОНЕНТУ|INSTALLADDIN|
|УСТАНОВИТЬРАСШИРЕНИЕРАБОТЫСФАЙЛАМИ|INSTALLFILESYSTEMEXTENSION|
|УСТАНОВИТЬРАСШИРЕНИЕРАБОТЫСКРИПТОГРАФИЕЙ|INSTALLCRYPTOEXTENSION|
|ПОМЕСТИТЬФАЙЛ|PUTFILE|

## Примеры

```bsl
// Пример "Плохо"
Предупреждение(НСтр("ru = 'Выберите документ!'; en = 'Select a document!'"), 10);

// Пример "Хорошо"
ПоказатьПредупреждение(, НСтр("ru = 'Выберите документ!'; en = 'Select a document!'"), 10);
```

## Источники

* [Ограничение на использование модальных окон и синхронных вызовов](https://its.1c.ru/db/v8std/content/703/hdoc/)
* Полезная информация: [Отказ от использования модальных окон](https://its.1c.ru/db/metod8dev#content:5272:hdoc)

## Сниппеты

<!-- Блоки ниже заполняются автоматически, не трогать -->
### Экранирование кода

```bsl
// BSLLS:UsingModalWindows-off
// BSLLS:UsingModalWindows-on
```

### Параметр конфигурационного файла

```json
"UsingModalWindows": {
    "forceModalityMode": false
}
```
