# Неверно задан обработчик метода http-сервиса (WrongHttpServiceHandler)

|   Тип    |    Поддерживаются<br>языки    |  Важность   |    Включена<br>по умолчанию    |    Время на<br>исправление (мин)    |             Теги              |
|:--------:|:-----------------------------:|:-----------:|:------------------------------:|:-----------------------------------:|:-----------------------------:|
| `Ошибка` |             `BSL`             | `Критичный` |              `Да`              |                `10`                 |    `suspicious`<br>`error`    |

<!-- Блоки выше заполняются автоматически, не трогать -->
## Описание диагностики
<!-- Описание диагностики заполняется вручную. Необходимо понятным языком описать смысл и схему работу -->
При отсутствии обработчика метода http-сервиса обращение к данному методу не выдаст ни самих данных, ни ошибки на стороне клиента сервиса, ни ошибки на стороне самого сервиса.

Также важно помнить, что метод http-сервиса должен принимать только один параметр.

Конфигуратор замечает нарушения указанных ограничений только при включенном флаге "Проверка существования назначенных обработчиков".

## Примеры
<!-- В данном разделе приводятся примеры, на которые диагностика срабатывает, а также можно привести пример, как можно исправить ситуацию -->
Неверный метод-обработчик с пустым телом
```bsl
Функция ХранилищеИИдентификаторGETЗапрос(Запрос)

КонецФункции
```

Правильный метод-обработчик - указан всего один параметр и есть тело метода
```bsl
Функция ХранилищеИИдентификаторGETЗапрос(Запрос)
	Возврат МодульЗапросы.Обработчик(Запрос);
КонецФункции
```

Неверный метод-обработчик с неправильным количеством параметров
```bsl
Функция ХранилищеИИдентификаторGETЗапрос(Запрос, ДополнительныеПараметры)
	Возврат МодульЗапросы.Обработчик(Запрос);
КонецФункции
```

## Источники
<!-- Необходимо указывать ссылки на все источники, из которых почерпнута информация для создания диагностики -->
<!-- Примеры источников

* Источник: [Стандарт: Тексты модулей](https://its.1c.ru/db/v8std#content:456:hdoc)
* Полезная информация: [Отказ от использования модальных окон](https://its.1c.ru/db/metod8dev#content:5272:hdoc)
* Источник: [Cognitive complexity, ver. 1.4](https://www.sonarsource.com/docs/CognitiveComplexity.pdf) -->
* [Руководство разработчика 8.3.20 - Механизмы интернет-сервисов](https://its.1c.ru/db/v8320doc#bookmark:dev:TI000000783)
* [Web-сервисы и HTTP-сервисы - Методические рекомендации по конфигурированию от 1С](https://its.1c.ru/db/metod8dev/browse/13/-1/1989/2565/2567/2590)

## Сниппеты

<!-- Блоки ниже заполняются автоматически, не трогать -->
### Экранирование кода

```bsl
// BSLLS:WrongHttpServiceHandler-off
// BSLLS:WrongHttpServiceHandler-on
```

### Параметр конфигурационного файла

```json
"WrongHttpServiceHandler": false
```
