# Неверно задан обработчик операции web-сервиса (WrongWebServiceHandler)

|   Тип    |    Поддерживаются<br>языки    |  Важность   |    Включена<br>по умолчанию    |    Время на<br>исправление (мин)    |             Теги              |
|:--------:|:-----------------------------:|:-----------:|:------------------------------:|:-----------------------------------:|:-----------------------------:|
| `Ошибка` |             `BSL`             | `Критичный` |              `Да`              |                `10`                 |    `suspicious`<br>`error`    |

<!-- Блоки выше заполняются автоматически, не трогать -->
## Описание диагностики
<!-- Описание диагностики заполняется вручную. Необходимо понятным языком описать смысл и схему работу -->
При отсутствии обработчика операции web-сервиса обращение к данной операции не выдаст ни самих данных, ни ошибки на стороне клиента сервиса, ни ошибки на стороне самого сервиса.

Также важно помнить, что количество параметров операции web-сервиса должно совпадать с количество параметров, указанных в настройках операции web-сервиса.

Конфигуратор замечает нарушения указанных ограничений только при включенном флаге "Проверка существования назначенных обработчиков".

## Примеры
<!-- В данном разделе приводятся примеры, на которые диагностика срабатывает, а также можно привести пример, как можно исправить ситуацию -->
Неверный метод-обработчик с пустым телом
```bsl
Функция FillCatalogs(MobileDeviceID, MessageExchange)

КонецФункции
```

Правильный метод-обработчик - есть тело метода и указан правильный набор параметров 
```bsl
Функция FillCatalogs(MobileDeviceID, MessageExchange)
	Возврат МобильноеПриложениеЗаказыКлиентов.ЗагрузитьСправочники(MobileDeviceID, MessageExchange);
КонецФункции
```

Неверный метод-обработчик с неправильным количеством параметров
```bsl
Функция FillCatalogs(MobileDeviceID, MessageExchange, ДополнительныеПараметры)
	Возврат МобильноеПриложениеЗаказыКлиентов.ЗагрузитьСправочники(MobileDeviceID, MessageExchange);
КонецФункции
```

## Источники
<!-- Необходимо указывать ссылки на все источники, из которых почерпнута информация для создания диагностики -->
<!-- Примеры источников

* Источник: [Стандарт: Тексты модулей](https://its.1c.ru/db/v8std#content:456:hdoc)
* Полезная информация: [Отказ от использования модальных окон](https://its.1c.ru/db/metod8dev#content:5272:hdoc)
* Источник: [Cognitive complexity, ver. 1.4](https://www.sonarsource.com/docs/CognitiveComplexity.pdf) -->
* [Руководство разработчика 8.3.20 - Механизмы интернет-сервисов](https://its.1c.ru/db/v8320doc#bookmark:dev:TI000000783)
* [Web-сервисы и HTTP-сервисы - Методические рекомендации по конфигурированию от 1С](https://its.1c.ru/db/metod8dev/browse/13/-1/1989/2565/2567/2590)

## Сниппеты

<!-- Блоки ниже заполняются автоматически, не трогать -->
### Экранирование кода

```bsl
// BSLLS:WrongWebServiceHandler-off
// BSLLS:WrongWebServiceHandler-on
```

### Параметр конфигурационного файла

```json
"WrongWebServiceHandler": false
```
