/*
 * Decompiled with CFR 0.152.
 */
package com.github._1c_syntax.bsl.languageserver;

import com.github._1c_syntax.bsl.languageserver.LanguageClientHolder;
import com.github._1c_syntax.bsl.languageserver.WorkDoneProgressHelper;
import com.github._1c_syntax.bsl.languageserver.configuration.Language;
import com.github._1c_syntax.bsl.languageserver.configuration.LanguageServerConfiguration;
import com.github._1c_syntax.bsl.languageserver.context.ServerContext;
import com.github._1c_syntax.bsl.languageserver.context.events.ServerContextPopulatedEvent;
import com.github._1c_syntax.bsl.languageserver.providers.DiagnosticProvider;
import com.github._1c_syntax.bsl.languageserver.utils.NamedForkJoinWorkerThreadFactory;
import com.github._1c_syntax.bsl.languageserver.utils.Resources;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.beans.ConstructorProperties;
import java.util.Collection;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ForkJoinPool;
import java.util.concurrent.ForkJoinTask;
import lombok.Generated;
import org.springframework.context.event.EventListener;
import org.springframework.scheduling.annotation.Async;
import org.springframework.stereotype.Component;

@Component
public class AnalyzeProjectOnStart {
    private final LanguageServerConfiguration configuration;
    private final DiagnosticProvider diagnosticProvider;
    private final LanguageClientHolder languageClientHolder;
    private final WorkDoneProgressHelper workDoneProgressHelper;

    @EventListener
    @Async
    public void handleEvent(ServerContextPopulatedEvent event) {
        if (!this.configuration.getDiagnosticsOptions().isAnalyzeOnStart()) {
            return;
        }
        if (!this.languageClientHolder.isConnected()) {
            return;
        }
        ServerContext serverContext = event.getSource();
        Collection documentContexts = serverContext.getDocuments().values();
        WorkDoneProgressHelper.WorkDoneProgressReporter progress = this.workDoneProgressHelper.createProgress(documentContexts.size(), this.getMessage("filesSuffix"));
        progress.beginProgress(this.getMessage("analyzeProject"));
        NamedForkJoinWorkerThreadFactory factory = new NamedForkJoinWorkerThreadFactory("analyze-on-start-");
        ForkJoinPool executorService = new ForkJoinPool(ForkJoinPool.getCommonPoolParallelism(), (ForkJoinPool.ForkJoinWorkerThreadFactory)factory, null, true);
        try {
            ((ForkJoinTask)executorService.submit(() -> documentContexts.parallelStream().forEach(documentContext -> {
                progress.tick();
                serverContext.rebuildDocument(documentContext);
                this.diagnosticProvider.computeAndPublishDiagnostics(documentContext);
                serverContext.tryClearDocument(documentContext);
            }))).get();
        }
        catch (ExecutionException e) {
            throw new RuntimeException("Can't analyze project on start", e);
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            throw new RuntimeException("Interrupted while analyzing project on start", e);
        }
        finally {
            executorService.shutdown();
        }
        progress.endProgress(this.getMessage("projectAnalyzed"));
    }

    private String getMessage(String key) {
        return Resources.getResourceString((Language)this.configuration.getLanguage(), this.getClass(), (String)key);
    }

    @ConstructorProperties(value={"configuration", "diagnosticProvider", "languageClientHolder", "workDoneProgressHelper"})
    @SuppressFBWarnings(justification="generated code")
    @Generated
    public AnalyzeProjectOnStart(LanguageServerConfiguration configuration, DiagnosticProvider diagnosticProvider, LanguageClientHolder languageClientHolder, WorkDoneProgressHelper workDoneProgressHelper) {
        this.configuration = configuration;
        this.diagnosticProvider = diagnosticProvider;
        this.languageClientHolder = languageClientHolder;
        this.workDoneProgressHelper = workDoneProgressHelper;
    }
}

