/*
 * Decompiled with CFR 0.152.
 */
package com.github._1c_syntax.bsl.languageserver;

import com.github._1c_syntax.bsl.languageserver.cli.AnalyzeCommand;
import com.github._1c_syntax.bsl.languageserver.cli.FormatCommand;
import com.github._1c_syntax.bsl.languageserver.cli.LanguageServerStartCommand;
import com.github._1c_syntax.bsl.languageserver.cli.VersionCommand;
import com.github._1c_syntax.bsl.languageserver.cli.WebsocketCommand;
import com.github._1c_syntax.utils.CaseInsensitivePattern;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.beans.ConstructorProperties;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Set;
import java.util.concurrent.Callable;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import lombok.Generated;
import org.springframework.boot.ExitCodeGenerator;
import org.springframework.boot.SpringApplication;
import org.springframework.boot.WebApplicationType;
import org.springframework.boot.autoconfigure.SpringBootApplication;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.boot.builder.SpringApplicationBuilder;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ConfigurableApplicationContext;
import org.springframework.stereotype.Component;
import picocli.CommandLine;

/*
 * Exception performing whole class analysis ignored.
 */
@CommandLine.Command(name="bsl-language-server", subcommands={AnalyzeCommand.class, FormatCommand.class, VersionCommand.class, LanguageServerStartCommand.class, WebsocketCommand.class}, usageHelpAutoWidth=true, synopsisSubcommandLabel="[COMMAND [ARGS]]", footer={"@|green Copyright(c) 2018-2022|@"}, header={"@|green BSL language server|@"})
@SpringBootApplication(scanBasePackageClasses={BSLLSPLauncher.class})
@Component
@ConditionalOnProperty(prefix="app.command.line.runner", value={"enabled"}, havingValue="true", matchIfMissing=true)
public class BSLLSPLauncher
implements Callable<Integer>,
ExitCodeGenerator {
    private static final String DEFAULT_COMMAND = "lsp";
    @CommandLine.Option(names={"-h", "--help"}, usageHelp=true, description={"Show this help message and exit"})
    private boolean usageHelpRequested;
    @CommandLine.Option(names={"-c", "--configuration"}, description={"Path to language server configuration file"}, paramLabel="<path>", defaultValue="")
    private String configurationOption;
    @CommandLine.Unmatched
    private List<String> unmatched;
    private final Set<Pattern> allowedAdditionalArgs = Set.of(CaseInsensitivePattern.compile((String)"--spring\\."), CaseInsensitivePattern.compile((String)"--app\\."), CaseInsensitivePattern.compile((String)"--logging\\."), CaseInsensitivePattern.compile((String)"--debug"));
    private final CommandLine.IFactory picocliFactory;
    private int exitCode;

    public static void main(String[] args) {
        ConfigurableApplicationContext applicationContext = new SpringApplicationBuilder(new Class[]{BSLLSPLauncher.class}).web(BSLLSPLauncher.getWebApplicationType((String[])args)).run(args);
        BSLLSPLauncher launcher = (BSLLSPLauncher)applicationContext.getBean(BSLLSPLauncher.class);
        launcher.run(args);
        if (launcher.getExitCode() >= 0) {
            System.exit(SpringApplication.exit((ApplicationContext)applicationContext, (ExitCodeGenerator[])new ExitCodeGenerator[0]));
        }
    }

    public void run(String ... args) {
        CommandLine cmd = new CommandLine((Object)this, this.picocliFactory);
        if (args.length == 0) {
            args = BSLLSPLauncher.addDefaultCommand((String[])args);
        } else {
            CommandLine.ParseResult parseResult = cmd.parseArgs(args);
            List<String> unmatchedArgs = parseResult.unmatched().stream().filter(s -> this.allowedAdditionalArgs.stream().noneMatch(pattern -> pattern.matcher((CharSequence)s).matches())).collect(Collectors.toList());
            if (!unmatchedArgs.isEmpty()) {
                unmatchedArgs.forEach(s -> cmd.getErr().println("Unknown option: '" + s + "'"));
                cmd.usage(cmd.getOut());
                this.exitCode = cmd.getCommandSpec().exitCodeOnInvalidInput();
                return;
            }
            if (!parseResult.hasSubcommand() && !parseResult.isUsageHelpRequested()) {
                args = BSLLSPLauncher.addDefaultCommand((String[])args);
            }
        }
        this.exitCode = cmd.execute(args);
    }

    private static String[] addDefaultCommand(String[] args) {
        ArrayList<String> tmpList = new ArrayList<String>(Arrays.asList(args));
        tmpList.add(0, "lsp");
        args = tmpList.toArray(new String[0]);
        return args;
    }

    public int getExitCode() {
        return this.exitCode;
    }

    @Override
    public Integer call() {
        return 0;
    }

    private static WebApplicationType getWebApplicationType(String[] args) {
        List<String> argsList = Arrays.asList(args);
        WebApplicationType webApplicationType = argsList.contains("-w") || argsList.contains("websocket") ? WebApplicationType.SERVLET : WebApplicationType.NONE;
        return webApplicationType;
    }

    @ConstructorProperties(value={"picocliFactory"})
    @SuppressFBWarnings(justification="generated code")
    @Generated
    public BSLLSPLauncher(CommandLine.IFactory picocliFactory) {
        this.picocliFactory = picocliFactory;
    }
}

