/*
 * Decompiled with CFR 0.152.
 */
package com.github._1c_syntax.bsl.languageserver;

import com.github._1c_syntax.bsl.languageserver.aop.SentryAspect;
import com.github._1c_syntax.bsl.languageserver.codelenses.CodeLensData;
import com.github._1c_syntax.bsl.languageserver.configuration.LanguageServerConfiguration;
import com.github._1c_syntax.bsl.languageserver.configuration.diagnostics.ComputeTrigger;
import com.github._1c_syntax.bsl.languageserver.context.DocumentContext;
import com.github._1c_syntax.bsl.languageserver.context.ServerContext;
import com.github._1c_syntax.bsl.languageserver.jsonrpc.DiagnosticParams;
import com.github._1c_syntax.bsl.languageserver.jsonrpc.Diagnostics;
import com.github._1c_syntax.bsl.languageserver.jsonrpc.ProtocolExtension;
import com.github._1c_syntax.bsl.languageserver.providers.CallHierarchyProvider;
import com.github._1c_syntax.bsl.languageserver.providers.CodeActionProvider;
import com.github._1c_syntax.bsl.languageserver.providers.CodeLensProvider;
import com.github._1c_syntax.bsl.languageserver.providers.ColorProvider;
import com.github._1c_syntax.bsl.languageserver.providers.DefinitionProvider;
import com.github._1c_syntax.bsl.languageserver.providers.DiagnosticProvider;
import com.github._1c_syntax.bsl.languageserver.providers.DocumentLinkProvider;
import com.github._1c_syntax.bsl.languageserver.providers.DocumentSymbolProvider;
import com.github._1c_syntax.bsl.languageserver.providers.FoldingRangeProvider;
import com.github._1c_syntax.bsl.languageserver.providers.FormatProvider;
import com.github._1c_syntax.bsl.languageserver.providers.HoverProvider;
import com.github._1c_syntax.bsl.languageserver.providers.InlayHintProvider;
import com.github._1c_syntax.bsl.languageserver.providers.ReferencesProvider;
import com.github._1c_syntax.bsl.languageserver.providers.RenameProvider;
import com.github._1c_syntax.bsl.languageserver.providers.SelectionRangeProvider;
import com.github._1c_syntax.bsl.languageserver.utils.Ranges;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import jakarta.annotation.PreDestroy;
import java.beans.ConstructorProperties;
import java.net.URI;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.ThreadFactory;
import lombok.Generated;
import org.eclipse.lsp4j.CallHierarchyIncomingCall;
import org.eclipse.lsp4j.CallHierarchyIncomingCallsParams;
import org.eclipse.lsp4j.CallHierarchyItem;
import org.eclipse.lsp4j.CallHierarchyOutgoingCall;
import org.eclipse.lsp4j.CallHierarchyOutgoingCallsParams;
import org.eclipse.lsp4j.CallHierarchyPrepareParams;
import org.eclipse.lsp4j.CodeAction;
import org.eclipse.lsp4j.CodeActionParams;
import org.eclipse.lsp4j.CodeLens;
import org.eclipse.lsp4j.CodeLensParams;
import org.eclipse.lsp4j.ColorInformation;
import org.eclipse.lsp4j.ColorPresentation;
import org.eclipse.lsp4j.ColorPresentationParams;
import org.eclipse.lsp4j.Command;
import org.eclipse.lsp4j.DefinitionParams;
import org.eclipse.lsp4j.Diagnostic;
import org.eclipse.lsp4j.DidChangeTextDocumentParams;
import org.eclipse.lsp4j.DidCloseTextDocumentParams;
import org.eclipse.lsp4j.DidOpenTextDocumentParams;
import org.eclipse.lsp4j.DidSaveTextDocumentParams;
import org.eclipse.lsp4j.DocumentColorParams;
import org.eclipse.lsp4j.DocumentFormattingParams;
import org.eclipse.lsp4j.DocumentLink;
import org.eclipse.lsp4j.DocumentLinkParams;
import org.eclipse.lsp4j.DocumentRangeFormattingParams;
import org.eclipse.lsp4j.DocumentSymbol;
import org.eclipse.lsp4j.DocumentSymbolParams;
import org.eclipse.lsp4j.FoldingRange;
import org.eclipse.lsp4j.FoldingRangeRequestParams;
import org.eclipse.lsp4j.Hover;
import org.eclipse.lsp4j.HoverParams;
import org.eclipse.lsp4j.InlayHint;
import org.eclipse.lsp4j.InlayHintParams;
import org.eclipse.lsp4j.Location;
import org.eclipse.lsp4j.LocationLink;
import org.eclipse.lsp4j.PrepareRenameDefaultBehavior;
import org.eclipse.lsp4j.PrepareRenameParams;
import org.eclipse.lsp4j.PrepareRenameResult;
import org.eclipse.lsp4j.Range;
import org.eclipse.lsp4j.ReferenceParams;
import org.eclipse.lsp4j.RenameParams;
import org.eclipse.lsp4j.SelectionRange;
import org.eclipse.lsp4j.SelectionRangeParams;
import org.eclipse.lsp4j.SymbolInformation;
import org.eclipse.lsp4j.TextDocumentContentChangeEvent;
import org.eclipse.lsp4j.TextDocumentItem;
import org.eclipse.lsp4j.TextDocumentPositionParams;
import org.eclipse.lsp4j.TextEdit;
import org.eclipse.lsp4j.WorkspaceEdit;
import org.eclipse.lsp4j.jsonrpc.messages.Either;
import org.eclipse.lsp4j.jsonrpc.messages.Either3;
import org.eclipse.lsp4j.services.TextDocumentService;
import org.springframework.scheduling.concurrent.CustomizableThreadFactory;
import org.springframework.stereotype.Component;

@Component
public class BSLTextDocumentService
implements TextDocumentService,
ProtocolExtension {
    private final ServerContext context;
    private final LanguageServerConfiguration configuration;
    private final DiagnosticProvider diagnosticProvider;
    private final CodeActionProvider codeActionProvider;
    private final CodeLensProvider codeLensProvider;
    private final DocumentLinkProvider documentLinkProvider;
    private final DocumentSymbolProvider documentSymbolProvider;
    private final FoldingRangeProvider foldingRangeProvider;
    private final FormatProvider formatProvider;
    private final HoverProvider hoverProvider;
    private final ReferencesProvider referencesProvider;
    private final DefinitionProvider definitionProvider;
    private final CallHierarchyProvider callHierarchyProvider;
    private final SelectionRangeProvider selectionRangeProvider;
    private final ColorProvider colorProvider;
    private final RenameProvider renameProvider;
    private final InlayHintProvider inlayHintProvider;
    private final ExecutorService executorService = Executors.newCachedThreadPool((ThreadFactory)new CustomizableThreadFactory("text-document-service-"));

    @PreDestroy
    private void onDestroy() {
        this.executorService.shutdown();
    }

    public CompletableFuture<Hover> hover(HoverParams params) {
        try {
            DocumentContext documentContext = this.context.getDocument(params.getTextDocument().getUri());
            if (documentContext == null) {
                return CompletableFuture.completedFuture(null);
            }
            return CompletableFuture.supplyAsync(() -> this.hoverProvider.getHover(documentContext, params).orElse(null), this.executorService);
        }
        catch (Throwable throwable) {
            SentryAspect.aspectOf().logThrowingLSPCall(throwable);
            throw throwable;
        }
    }

    public CompletableFuture<Either<List<? extends Location>, List<? extends LocationLink>>> definition(DefinitionParams params) {
        try {
            DocumentContext documentContext = this.context.getDocument(params.getTextDocument().getUri());
            if (documentContext == null) {
                return CompletableFuture.completedFuture(Either.forRight(Collections.emptyList()));
            }
            return CompletableFuture.supplyAsync(() -> Either.forRight((Object)this.definitionProvider.getDefinition(documentContext, params)), this.executorService);
        }
        catch (Throwable throwable) {
            SentryAspect.aspectOf().logThrowingLSPCall(throwable);
            throw throwable;
        }
    }

    public CompletableFuture<List<? extends Location>> references(ReferenceParams params) {
        try {
            DocumentContext documentContext = this.context.getDocument(params.getTextDocument().getUri());
            if (documentContext == null) {
                return CompletableFuture.completedFuture(Collections.emptyList());
            }
            return CompletableFuture.supplyAsync(() -> this.referencesProvider.getReferences(documentContext, params), this.executorService);
        }
        catch (Throwable throwable) {
            SentryAspect.aspectOf().logThrowingLSPCall(throwable);
            throw throwable;
        }
    }

    public CompletableFuture<List<Either<SymbolInformation, DocumentSymbol>>> documentSymbol(DocumentSymbolParams params) {
        try {
            DocumentContext documentContext = this.context.getDocument(params.getTextDocument().getUri());
            if (documentContext == null) {
                return CompletableFuture.completedFuture(null);
            }
            return CompletableFuture.supplyAsync(() -> this.documentSymbolProvider.getDocumentSymbols(documentContext).stream().map(Either::forRight).toList(), this.executorService);
        }
        catch (Throwable throwable) {
            SentryAspect.aspectOf().logThrowingLSPCall(throwable);
            throw throwable;
        }
    }

    public CompletableFuture<List<Either<Command, CodeAction>>> codeAction(CodeActionParams params) {
        try {
            DocumentContext documentContext = this.context.getDocument(params.getTextDocument().getUri());
            if (documentContext == null) {
                return CompletableFuture.completedFuture(null);
            }
            return CompletableFuture.supplyAsync(() -> this.codeActionProvider.getCodeActions(params, documentContext), this.executorService);
        }
        catch (Throwable throwable) {
            SentryAspect.aspectOf().logThrowingLSPCall(throwable);
            throw throwable;
        }
    }

    public CompletableFuture<List<? extends CodeLens>> codeLens(CodeLensParams params) {
        try {
            DocumentContext documentContext = this.context.getDocument(params.getTextDocument().getUri());
            if (documentContext == null) {
                return CompletableFuture.completedFuture(Collections.emptyList());
            }
            return CompletableFuture.supplyAsync(() -> this.codeLensProvider.getCodeLens(documentContext), this.executorService);
        }
        catch (Throwable throwable) {
            SentryAspect.aspectOf().logThrowingLSPCall(throwable);
            throw throwable;
        }
    }

    public CompletableFuture<CodeLens> resolveCodeLens(CodeLens unresolved) {
        try {
            CodeLensData data = this.codeLensProvider.extractData(unresolved);
            DocumentContext documentContext = this.context.getDocument(data.getUri());
            if (documentContext == null) {
                return CompletableFuture.completedFuture(unresolved);
            }
            return CompletableFuture.supplyAsync(() -> this.codeLensProvider.resolveCodeLens(documentContext, unresolved, data), this.executorService);
        }
        catch (Throwable throwable) {
            SentryAspect.aspectOf().logThrowingLSPCall(throwable);
            throw throwable;
        }
    }

    public CompletableFuture<List<? extends TextEdit>> formatting(DocumentFormattingParams params) {
        try {
            DocumentContext documentContext = this.context.getDocument(params.getTextDocument().getUri());
            if (documentContext == null) {
                return CompletableFuture.completedFuture(null);
            }
            return CompletableFuture.supplyAsync(() -> this.formatProvider.getFormatting(params, documentContext), this.executorService);
        }
        catch (Throwable throwable) {
            SentryAspect.aspectOf().logThrowingLSPCall(throwable);
            throw throwable;
        }
    }

    public CompletableFuture<List<? extends TextEdit>> rangeFormatting(DocumentRangeFormattingParams params) {
        try {
            DocumentContext documentContext = this.context.getDocument(params.getTextDocument().getUri());
            if (documentContext == null) {
                return CompletableFuture.completedFuture(null);
            }
            return CompletableFuture.supplyAsync(() -> this.formatProvider.getRangeFormatting(params, documentContext), this.executorService);
        }
        catch (Throwable throwable) {
            SentryAspect.aspectOf().logThrowingLSPCall(throwable);
            throw throwable;
        }
    }

    public CompletableFuture<List<FoldingRange>> foldingRange(FoldingRangeRequestParams params) {
        try {
            DocumentContext documentContext = this.context.getDocument(params.getTextDocument().getUri());
            if (documentContext == null) {
                return CompletableFuture.completedFuture(null);
            }
            return CompletableFuture.supplyAsync(() -> this.foldingRangeProvider.getFoldingRange(documentContext), this.executorService);
        }
        catch (Throwable throwable) {
            SentryAspect.aspectOf().logThrowingLSPCall(throwable);
            throw throwable;
        }
    }

    public CompletableFuture<List<CallHierarchyItem>> prepareCallHierarchy(CallHierarchyPrepareParams params) {
        try {
            DocumentContext documentContext = this.context.getDocument(params.getTextDocument().getUri());
            if (documentContext == null) {
                return CompletableFuture.completedFuture(null);
            }
            return CompletableFuture.supplyAsync(() -> {
                List callHierarchyItems = this.callHierarchyProvider.prepareCallHierarchy(documentContext, params);
                if (callHierarchyItems.isEmpty()) {
                    return null;
                }
                return callHierarchyItems;
            }, this.executorService);
        }
        catch (Throwable throwable) {
            SentryAspect.aspectOf().logThrowingLSPCall(throwable);
            throw throwable;
        }
    }

    public CompletableFuture<List<CallHierarchyIncomingCall>> callHierarchyIncomingCalls(CallHierarchyIncomingCallsParams params) {
        try {
            DocumentContext documentContext = this.context.getDocument(params.getItem().getUri());
            if (documentContext == null) {
                return CompletableFuture.completedFuture(Collections.emptyList());
            }
            return CompletableFuture.supplyAsync(() -> this.callHierarchyProvider.incomingCalls(documentContext, params), this.executorService);
        }
        catch (Throwable throwable) {
            SentryAspect.aspectOf().logThrowingLSPCall(throwable);
            throw throwable;
        }
    }

    public CompletableFuture<List<CallHierarchyOutgoingCall>> callHierarchyOutgoingCalls(CallHierarchyOutgoingCallsParams params) {
        try {
            DocumentContext documentContext = this.context.getDocument(params.getItem().getUri());
            if (documentContext == null) {
                return CompletableFuture.completedFuture(Collections.emptyList());
            }
            return CompletableFuture.supplyAsync(() -> this.callHierarchyProvider.outgoingCalls(documentContext, params), this.executorService);
        }
        catch (Throwable throwable) {
            SentryAspect.aspectOf().logThrowingLSPCall(throwable);
            throw throwable;
        }
    }

    public CompletableFuture<List<SelectionRange>> selectionRange(SelectionRangeParams params) {
        try {
            DocumentContext documentContext = this.context.getDocument(params.getTextDocument().getUri());
            if (documentContext == null) {
                return CompletableFuture.completedFuture(Collections.emptyList());
            }
            return CompletableFuture.supplyAsync(() -> this.selectionRangeProvider.getSelectionRange(documentContext, params), this.executorService);
        }
        catch (Throwable throwable) {
            SentryAspect.aspectOf().logThrowingLSPCall(throwable);
            throw throwable;
        }
    }

    public CompletableFuture<List<ColorInformation>> documentColor(DocumentColorParams params) {
        try {
            DocumentContext documentContext = this.context.getDocument(params.getTextDocument().getUri());
            if (documentContext == null) {
                return CompletableFuture.completedFuture(Collections.emptyList());
            }
            return CompletableFuture.supplyAsync(() -> this.colorProvider.getDocumentColor(documentContext), this.executorService);
        }
        catch (Throwable throwable) {
            SentryAspect.aspectOf().logThrowingLSPCall(throwable);
            throw throwable;
        }
    }

    public CompletableFuture<List<ColorPresentation>> colorPresentation(ColorPresentationParams params) {
        try {
            DocumentContext documentContext = this.context.getDocument(params.getTextDocument().getUri());
            if (documentContext == null) {
                return CompletableFuture.completedFuture(Collections.emptyList());
            }
            return CompletableFuture.supplyAsync(() -> this.colorProvider.getColorPresentation(documentContext, params), this.executorService);
        }
        catch (Throwable throwable) {
            SentryAspect.aspectOf().logThrowingLSPCall(throwable);
            throw throwable;
        }
    }

    public CompletableFuture<List<InlayHint>> inlayHint(InlayHintParams params) {
        try {
            DocumentContext documentContext = this.context.getDocument(params.getTextDocument().getUri());
            if (documentContext == null) {
                return CompletableFuture.completedFuture(Collections.emptyList());
            }
            return CompletableFuture.supplyAsync(() -> this.inlayHintProvider.getInlayHint(documentContext, params), this.executorService);
        }
        catch (Throwable throwable) {
            SentryAspect.aspectOf().logThrowingLSPCall(throwable);
            throw throwable;
        }
    }

    public void didOpen(DidOpenTextDocumentParams params) {
        try {
            TextDocumentItem textDocumentItem = params.getTextDocument();
            DocumentContext documentContext = this.context.addDocument(URI.create(textDocumentItem.getUri()));
            this.context.openDocument(documentContext, textDocumentItem.getText(), Integer.valueOf(textDocumentItem.getVersion()));
            if (this.configuration.getDiagnosticsOptions().getComputeTrigger() != ComputeTrigger.NEVER) {
                this.validate(documentContext);
            }
            return;
        }
        catch (Throwable throwable) {
            SentryAspect.aspectOf().logThrowingLSPCall(throwable);
            throw throwable;
        }
    }

    public void didChange(DidChangeTextDocumentParams params) {
        try {
            DocumentContext documentContext = this.context.getDocument(params.getTextDocument().getUri());
            if (documentContext == null) {
                return;
            }
            this.context.rebuildDocument(documentContext, ((TextDocumentContentChangeEvent)params.getContentChanges().get(0)).getText(), params.getTextDocument().getVersion());
            if (this.configuration.getDiagnosticsOptions().getComputeTrigger() == ComputeTrigger.ONTYPE) {
                this.validate(documentContext);
            }
            return;
        }
        catch (Throwable throwable) {
            SentryAspect.aspectOf().logThrowingLSPCall(throwable);
            throw throwable;
        }
    }

    public void didClose(DidCloseTextDocumentParams params) {
        try {
            DocumentContext documentContext = this.context.getDocument(params.getTextDocument().getUri());
            if (documentContext == null) {
                return;
            }
            this.context.closeDocument(documentContext);
            this.diagnosticProvider.publishEmptyDiagnosticList(documentContext);
            return;
        }
        catch (Throwable throwable) {
            SentryAspect.aspectOf().logThrowingLSPCall(throwable);
            throw throwable;
        }
    }

    public void didSave(DidSaveTextDocumentParams params) {
        try {
            DocumentContext documentContext = this.context.getDocument(params.getTextDocument().getUri());
            if (documentContext == null) {
                return;
            }
            if (this.configuration.getDiagnosticsOptions().getComputeTrigger() != ComputeTrigger.NEVER) {
                this.validate(documentContext);
            }
            return;
        }
        catch (Throwable throwable) {
            SentryAspect.aspectOf().logThrowingLSPCall(throwable);
            throw throwable;
        }
    }

    public CompletableFuture<List<DocumentLink>> documentLink(DocumentLinkParams params) {
        try {
            DocumentContext documentContext = this.context.getDocument(params.getTextDocument().getUri());
            if (documentContext == null) {
                return CompletableFuture.completedFuture(null);
            }
            return CompletableFuture.supplyAsync(() -> this.documentLinkProvider.getDocumentLinks(documentContext), this.executorService);
        }
        catch (Throwable throwable) {
            SentryAspect.aspectOf().logThrowingLSPCall(throwable);
            throw throwable;
        }
    }

    public CompletableFuture<Diagnostics> diagnostics(DiagnosticParams params) {
        try {
            DocumentContext documentContext = this.context.getDocument(params.getTextDocument().getUri());
            if (documentContext == null) {
                return CompletableFuture.completedFuture(Diagnostics.EMPTY);
            }
            return CompletableFuture.supplyAsync(() -> {
                List<Diagnostic> diagnostics = documentContext.getDiagnostics();
                Range range = params.getRange();
                if (range != null) {
                    diagnostics = diagnostics.stream().filter(diagnostic -> Ranges.containsRange((Range)range, (Range)diagnostic.getRange())).toList();
                }
                return new Diagnostics(diagnostics, Integer.valueOf(documentContext.getVersion()));
            });
        }
        catch (Throwable throwable) {
            SentryAspect.aspectOf().logThrowingLSPCall(throwable);
            throw throwable;
        }
    }

    public CompletableFuture<Either3<Range, PrepareRenameResult, PrepareRenameDefaultBehavior>> prepareRename(PrepareRenameParams params) {
        try {
            DocumentContext documentContext = this.context.getDocument(params.getTextDocument().getUri());
            if (documentContext == null) {
                return CompletableFuture.completedFuture(null);
            }
            return CompletableFuture.supplyAsync(() -> Either3.forFirst((Object)this.renameProvider.getPrepareRename(documentContext, (TextDocumentPositionParams)params)), this.executorService);
        }
        catch (Throwable throwable) {
            SentryAspect.aspectOf().logThrowingLSPCall(throwable);
            throw throwable;
        }
    }

    public CompletableFuture<WorkspaceEdit> rename(RenameParams params) {
        try {
            DocumentContext documentContext = this.context.getDocument(params.getTextDocument().getUri());
            if (documentContext == null) {
                return CompletableFuture.completedFuture(null);
            }
            return CompletableFuture.supplyAsync(() -> this.renameProvider.getRename(documentContext, params), this.executorService);
        }
        catch (Throwable throwable) {
            SentryAspect.aspectOf().logThrowingLSPCall(throwable);
            throw throwable;
        }
    }

    public void reset() {
        try {
            this.context.clear();
            return;
        }
        catch (Throwable throwable) {
            SentryAspect.aspectOf().logThrowingLSPCall(throwable);
            throw throwable;
        }
    }

    private void validate(DocumentContext documentContext) {
        this.diagnosticProvider.computeAndPublishDiagnostics(documentContext);
    }

    @ConstructorProperties(value={"context", "configuration", "diagnosticProvider", "codeActionProvider", "codeLensProvider", "documentLinkProvider", "documentSymbolProvider", "foldingRangeProvider", "formatProvider", "hoverProvider", "referencesProvider", "definitionProvider", "callHierarchyProvider", "selectionRangeProvider", "colorProvider", "renameProvider", "inlayHintProvider"})
    @SuppressFBWarnings(justification="generated code")
    @Generated
    public BSLTextDocumentService(ServerContext context, LanguageServerConfiguration configuration, DiagnosticProvider diagnosticProvider, CodeActionProvider codeActionProvider, CodeLensProvider codeLensProvider, DocumentLinkProvider documentLinkProvider, DocumentSymbolProvider documentSymbolProvider, FoldingRangeProvider foldingRangeProvider, FormatProvider formatProvider, HoverProvider hoverProvider, ReferencesProvider referencesProvider, DefinitionProvider definitionProvider, CallHierarchyProvider callHierarchyProvider, SelectionRangeProvider selectionRangeProvider, ColorProvider colorProvider, RenameProvider renameProvider, InlayHintProvider inlayHintProvider) {
        this.context = context;
        this.configuration = configuration;
        this.diagnosticProvider = diagnosticProvider;
        this.codeActionProvider = codeActionProvider;
        this.codeLensProvider = codeLensProvider;
        this.documentLinkProvider = documentLinkProvider;
        this.documentSymbolProvider = documentSymbolProvider;
        this.foldingRangeProvider = foldingRangeProvider;
        this.formatProvider = formatProvider;
        this.hoverProvider = hoverProvider;
        this.referencesProvider = referencesProvider;
        this.definitionProvider = definitionProvider;
        this.callHierarchyProvider = callHierarchyProvider;
        this.selectionRangeProvider = selectionRangeProvider;
        this.colorProvider = colorProvider;
        this.renameProvider = renameProvider;
        this.inlayHintProvider = inlayHintProvider;
    }
}

