/*
 * Decompiled with CFR 0.152.
 */
package com.github._1c_syntax.bsl.languageserver;

import com.github._1c_syntax.bsl.languageserver.ClientCapabilitiesHolder;
import com.github._1c_syntax.bsl.languageserver.LanguageClientHolder;
import com.github._1c_syntax.bsl.languageserver.WorkDoneProgressHelper;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.beans.ConstructorProperties;
import java.util.UUID;
import lombok.Generated;
import org.eclipse.lsp4j.ClientCapabilities;
import org.eclipse.lsp4j.WindowClientCapabilities;
import org.eclipse.lsp4j.WorkDoneProgressCreateParams;
import org.eclipse.lsp4j.jsonrpc.messages.Either;
import org.springframework.stereotype.Component;

@Component
public class WorkDoneProgressHelper {
    private final LanguageClientHolder languageClientHolder;
    private final ClientCapabilitiesHolder clientCapabilitiesHolder;
    private boolean isWorkDoneProgressSupported;

    public WorkDoneProgressReporter createProgress(int size, String messagePostfix) {
        this.isWorkDoneProgressSupported = this.clientCapabilitiesHolder.getCapabilities().map(ClientCapabilities::getWindow).map(WindowClientCapabilities::getWorkDoneProgress).orElse(false);
        if (!this.isWorkDoneProgressSupported) {
            return new WorkDoneProgressReporter(this, "", 0, "");
        }
        String token = UUID.randomUUID().toString();
        WorkDoneProgressCreateParams createProgressParams = new WorkDoneProgressCreateParams(Either.forLeft((Object)token));
        this.languageClientHolder.execIfConnected(languageClient -> languageClient.createProgress(createProgressParams));
        return new WorkDoneProgressReporter(this, token, size, messagePostfix);
    }

    @ConstructorProperties(value={"languageClientHolder", "clientCapabilitiesHolder"})
    @SuppressFBWarnings(justification="generated code")
    @Generated
    public WorkDoneProgressHelper(LanguageClientHolder languageClientHolder, ClientCapabilitiesHolder clientCapabilitiesHolder) {
        this.languageClientHolder = languageClientHolder;
        this.clientCapabilitiesHolder = clientCapabilitiesHolder;
    }
}

