/*
 * Decompiled with CFR 0.152.
 */
package com.github._1c_syntax.bsl.languageserver.aop.measures;

import com.github._1c_syntax.bsl.languageserver.aop.measures.ConditionalOnMeasuresEnabled;
import com.github._1c_syntax.bsl.languageserver.aop.measures.MeasureCollector;
import com.github._1c_syntax.bsl.languageserver.context.DocumentContext;
import com.github._1c_syntax.bsl.languageserver.context.events.DocumentContextContentChangedEvent;
import com.github._1c_syntax.bsl.languageserver.context.symbol.SymbolTree;
import com.github._1c_syntax.bsl.parser.SDBLTokenizer;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.beans.ConstructorProperties;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.context.event.EventListener;
import org.springframework.core.annotation.Order;
import org.springframework.stereotype.Component;

@Component
@ConditionalOnMeasuresEnabled
public class DocumentContextLazyDataMeasurer {
    @SuppressFBWarnings(justification="generated code")
    @Generated
    private static final Logger LOGGER = LoggerFactory.getLogger(DocumentContextLazyDataMeasurer.class);
    private final MeasureCollector measureCollector;

    @EventListener
    @Order
    public void handleEvent(DocumentContextContentChangedEvent event) {
        DocumentContext documentContext = event.getSource();
        LOGGER.debug("Take measurements for {}", (Object)documentContext.getUri());
        this.measureCollector.measureIt(() -> ((DocumentContext)documentContext).getQueries(), "context: queries");
        for (SDBLTokenizer sdblTokenizer : documentContext.getQueries()) {
            this.measureCollector.measureIt(() -> ((SDBLTokenizer)sdblTokenizer).getAst(), "context: queryAst");
        }
        this.measureCollector.measureIt(() -> ((SymbolTree)documentContext.getSymbolTree()).getChildrenFlat(), "context: symbolTree - childrenFlat");
        this.measureCollector.measureIt(() -> ((SymbolTree)documentContext.getSymbolTree()).getMethods(), "context: symbolTree - methods");
        this.measureCollector.measureIt(() -> ((SymbolTree)documentContext.getSymbolTree()).getVariables(), "context: symbolTree - variables");
        this.measureCollector.measureIt(() -> ((SymbolTree)documentContext.getSymbolTree()).getVariablesByName(), "context: symbolTree - variablesByName");
        this.measureCollector.measureIt(() -> ((SymbolTree)documentContext.getSymbolTree()).getMethodsByName(), "context: symbolTree - methodsByName");
        this.measureCollector.measureIt(() -> ((DocumentContext)documentContext).getDiagnosticIgnorance(), "context: diagnosticIgnorance");
        this.measureCollector.measureIt(() -> ((DocumentContext)documentContext).getCognitiveComplexityData(), "context: cognitiveComplexity");
        this.measureCollector.measureIt(() -> ((DocumentContext)documentContext).getCyclomaticComplexityData(), "context: cyclomaticComplexity");
        this.measureCollector.measureIt(() -> ((DocumentContext)documentContext).getMetrics(), "context: metrics");
    }

    @ConstructorProperties(value={"measureCollector"})
    @SuppressFBWarnings(justification="generated code")
    @Generated
    public DocumentContextLazyDataMeasurer(MeasureCollector measureCollector) {
        this.measureCollector = measureCollector;
    }
}

