/*
 * Decompiled with CFR 0.152.
 */
package com.github._1c_syntax.bsl.languageserver.cfg;

import com.github._1c_syntax.bsl.languageserver.cfg.StatementsBlockWriter;
import com.github._1c_syntax.bsl.parser.BSLParserRuleContext;
import java.util.ArrayDeque;
import java.util.Deque;

class StatementsBlockWriter {
    private final Deque<StatementsBlockRecord> blocks = new ArrayDeque();

    StatementsBlockWriter() {
    }

    public int size() {
        return this.blocks.size();
    }

    public StatementsBlockRecord enterBlock() {
        return this.enterBlock(new JumpInformationRecord());
    }

    public StatementsBlockRecord enterBlock(JumpInformationRecord newJumpStates) {
        StatementsBlockRecord current = this.getCurrentBlock();
        if (current != null) {
            if (newJumpStates.methodReturn == null) {
                newJumpStates.methodReturn = current.jumpContext.methodReturn;
            }
            if (newJumpStates.loopBreak == null) {
                newJumpStates.loopBreak = current.jumpContext.loopBreak;
            }
            if (newJumpStates.loopContinue == null) {
                newJumpStates.loopContinue = current.jumpContext.loopContinue;
            }
            if (newJumpStates.exceptionHandler == null) {
                newJumpStates.exceptionHandler = current.jumpContext.exceptionHandler;
            }
        }
        StatementsBlockRecord block = new StatementsBlockRecord(newJumpStates);
        this.blocks.push(block);
        return block;
    }

    public StatementsBlockRecord leaveBlock() {
        return (StatementsBlockRecord)this.blocks.pop();
    }

    public StatementsBlockRecord getCurrentBlock() {
        return (StatementsBlockRecord)this.blocks.peek();
    }

    public void addStatement(BSLParserRuleContext statement) {
        this.getCurrentBlock().add(statement);
    }
}

