/*
 * Decompiled with CFR 0.152.
 */
package com.github._1c_syntax.bsl.languageserver.cli;

import com.github._1c_syntax.bsl.languageserver.context.DocumentContext;
import com.github._1c_syntax.bsl.languageserver.context.ServerContext;
import com.github._1c_syntax.bsl.languageserver.providers.FormatProvider;
import com.github._1c_syntax.utils.Absolute;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.beans.ConstructorProperties;
import java.io.File;
import java.net.URI;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.Callable;
import java.util.regex.Pattern;
import lombok.Generated;
import me.tongfei.progressbar.ProgressBar;
import me.tongfei.progressbar.ProgressBarBuilder;
import me.tongfei.progressbar.ProgressBarStyle;
import org.apache.commons.io.FileUtils;
import org.eclipse.lsp4j.DocumentFormattingParams;
import org.eclipse.lsp4j.FormattingOptions;
import org.eclipse.lsp4j.TextEdit;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Component;
import picocli.CommandLine;

@CommandLine.Command(name="format", aliases={"-f", "--format"}, description={"Format files in source directory"}, usageHelpAutoWidth=true, footer={"@|green Copyright(c) 2018-2022|@"})
@Component
public class FormatCommand
implements Callable<Integer> {
    @SuppressFBWarnings(justification="generated code")
    @Generated
    private static final Logger LOGGER = LoggerFactory.getLogger(FormatCommand.class);
    private static final Pattern COMMA_PATTERN = Pattern.compile(",");
    private final ServerContext serverContext;
    private final FormatProvider formatProvider;
    @CommandLine.Option(names={"-h", "--help"}, usageHelp=true, description={"Show this help message and exit"})
    private boolean usageHelpRequested;
    @CommandLine.Option(names={"-s", "--srcDir", "--src"}, description={"Source directory or file"}, paramLabel="<path>", defaultValue="")
    private String srcDirOption;
    @CommandLine.Option(names={"-q", "--silent"}, description={"Silent mode"})
    private boolean silentMode;

    @Override
    public Integer call() {
        this.serverContext.clear();
        String[] filePaths = COMMA_PATTERN.split(this.srcDirOption);
        List files = this.findFilesForFormatting(filePaths);
        if (files.isEmpty()) {
            return 1;
        }
        if (this.silentMode) {
            files.parallelStream().forEach(arg_0 -> this.formatFile(arg_0));
        } else {
            try (ProgressBar pb = new ProgressBarBuilder().setTaskName("Formatting files...").setInitialMax((long)files.size()).setStyle(ProgressBarStyle.ASCII).build();){
                files.parallelStream().forEach(file -> {
                    pb.step();
                    this.formatFile(file);
                });
            }
        }
        return 0;
    }

    private List<File> findFilesForFormatting(String[] filePaths) {
        ArrayList<File> files = new ArrayList<File>();
        for (String filePath : filePaths) {
            Path srcDir = Absolute.path((String)filePath);
            if (!srcDir.toFile().exists()) {
                LOGGER.error("Source dir `{}` is not exists", (Object)srcDir);
                continue;
            }
            if (srcDir.toFile().isDirectory()) {
                files.addAll(FileUtils.listFiles((File)srcDir.toFile(), (String[])new String[]{"bsl", "os"}, (boolean)true));
                continue;
            }
            files.add(srcDir.toFile());
        }
        return files;
    }

    private void formatFile(File file) {
        URI uri = file.toURI();
        DocumentContext documentContext = this.serverContext.addDocument(uri);
        this.serverContext.rebuildDocument(documentContext);
        DocumentFormattingParams params = new DocumentFormattingParams();
        FormattingOptions options = new FormattingOptions();
        options.setInsertSpaces(false);
        params.setOptions(options);
        List formatting = this.formatProvider.getFormatting(params, documentContext);
        this.serverContext.removeDocument(uri);
        if (formatting.isEmpty()) {
            return;
        }
        TextEdit textEdit = (TextEdit)formatting.get(0);
        String newText = textEdit.getNewText();
        FileUtils.writeStringToFile((File)file, (String)newText, (Charset)StandardCharsets.UTF_8);
    }

    @ConstructorProperties(value={"serverContext", "formatProvider"})
    @SuppressFBWarnings(justification="generated code")
    @Generated
    public FormatCommand(ServerContext serverContext, FormatProvider formatProvider) {
        this.serverContext = serverContext;
        this.formatProvider = formatProvider;
    }
}

