/*
 * Decompiled with CFR 0.152.
 */
package com.github._1c_syntax.bsl.languageserver.cli;

import com.github._1c_syntax.bsl.languageserver.configuration.LanguageServerConfiguration;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.beans.ConstructorProperties;
import java.io.File;
import java.util.List;
import java.util.concurrent.Callable;
import lombok.Generated;
import org.eclipse.lsp4j.jsonrpc.Launcher;
import org.eclipse.lsp4j.services.LanguageClient;
import org.eclipse.lsp4j.services.LanguageClientAware;
import org.springframework.stereotype.Component;
import picocli.CommandLine;

@CommandLine.Command(name="lsp", aliases={"--lsp"}, description={"LSP server mode (default)"}, usageHelpAutoWidth=true, footer={"@|green Copyright(c) 2018-2022|@"})
@Component
public class LanguageServerStartCommand
implements Callable<Integer> {
    @CommandLine.Option(names={"-h", "--help"}, usageHelp=true, description={"Show this help message and exit"})
    private boolean usageHelpRequested;
    @CommandLine.Option(names={"-c", "--configuration"}, description={"Path to language server configuration file"}, paramLabel="<path>", defaultValue="")
    private String configurationOption;
    private final LanguageServerConfiguration configuration;
    private final Launcher<LanguageClient> launcher;
    private final List<LanguageClientAware> languageClientAwares;

    @Override
    public Integer call() {
        File configurationFile = new File(this.configurationOption);
        if (configurationFile.exists()) {
            this.configuration.update(configurationFile);
        }
        LanguageClient languageClient = (LanguageClient)this.launcher.getRemoteProxy();
        this.languageClientAwares.forEach(languageClientAware -> languageClientAware.connect(languageClient));
        this.launcher.startListening();
        return -1;
    }

    @ConstructorProperties(value={"configuration", "launcher", "languageClientAwares"})
    @SuppressFBWarnings(justification="generated code")
    @Generated
    public LanguageServerStartCommand(LanguageServerConfiguration configuration, Launcher<LanguageClient> launcher, List<LanguageClientAware> languageClientAwares) {
        this.configuration = configuration;
        this.launcher = launcher;
        this.languageClientAwares = languageClientAwares;
    }
}

