/*
 * Decompiled with CFR 0.152.
 */
package com.github._1c_syntax.bsl.languageserver.codeactions;

import com.github._1c_syntax.bsl.languageserver.codeactions.AbstractQuickFixSupplier;
import com.github._1c_syntax.bsl.languageserver.codeactions.CodeActionSupplier;
import com.github._1c_syntax.bsl.languageserver.codeactions.QuickFixSupplier;
import com.github._1c_syntax.bsl.languageserver.context.DocumentContext;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.beans.ConstructorProperties;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import lombok.Generated;
import org.eclipse.lsp4j.CodeAction;
import org.eclipse.lsp4j.CodeActionParams;
import org.eclipse.lsp4j.Diagnostic;

public abstract class AbstractQuickFixSupplier
implements CodeActionSupplier {
    protected final QuickFixSupplier quickFixSupplier;

    public List<CodeAction> getCodeActions(CodeActionParams params, DocumentContext documentContext) {
        List only = params.getContext().getOnly();
        if (only != null && !only.isEmpty() && !only.contains("quickfix")) {
            return Collections.emptyList();
        }
        List incomingDiagnostics = params.getContext().getDiagnostics();
        if (incomingDiagnostics.isEmpty()) {
            return Collections.emptyList();
        }
        Set computedDiagnostics = documentContext.getComputedDiagnostics().stream().map(LightDiagnostic::new).collect(Collectors.toSet());
        Stream<Diagnostic> diagnosticStream = incomingDiagnostics.stream().filter(diagnostic -> computedDiagnostics.contains(new LightDiagnostic(diagnostic)));
        return this.processDiagnosticStream(diagnosticStream, params, documentContext).collect(Collectors.toList());
    }

    protected abstract Stream<CodeAction> processDiagnosticStream(Stream<Diagnostic> var1, CodeActionParams var2, DocumentContext var3);

    @ConstructorProperties(value={"quickFixSupplier"})
    @SuppressFBWarnings(justification="generated code")
    @Generated
    public AbstractQuickFixSupplier(QuickFixSupplier quickFixSupplier) {
        this.quickFixSupplier = quickFixSupplier;
    }
}

