/*
 * Decompiled with CFR 0.152.
 */
package com.github._1c_syntax.bsl.languageserver.codeactions;

import com.github._1c_syntax.bsl.languageserver.diagnostics.QuickFixProvider;
import com.github._1c_syntax.bsl.languageserver.diagnostics.infrastructure.DiagnosticObjectProvider;
import com.github._1c_syntax.bsl.languageserver.diagnostics.metadata.DiagnosticCode;
import com.github._1c_syntax.bsl.languageserver.diagnostics.metadata.DiagnosticInfo;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.beans.ConstructorProperties;
import java.util.Map;
import java.util.Optional;
import lombok.Generated;
import org.eclipse.lsp4j.jsonrpc.messages.Either;
import org.springframework.stereotype.Component;

@Component
public class QuickFixSupplier {
    private final Map<String, DiagnosticInfo> diagnosticInfos;
    private final DiagnosticObjectProvider diagnosticObjectProvider;

    public <T extends Either<String, Integer>> Optional<Class<? extends QuickFixProvider>> getQuickFixClass(T diagnosticCode) {
        return Optional.ofNullable((DiagnosticInfo)this.diagnosticInfos.get(DiagnosticCode.getStringValue(diagnosticCode))).map(DiagnosticInfo::getDiagnosticClass).filter(QuickFixProvider.class::isAssignableFrom).map(aClass -> aClass);
    }

    public QuickFixProvider getQuickFixInstance(Class<? extends QuickFixProvider> quickFixProviderClass) {
        Class<? extends QuickFixProvider> diagnosticClass = quickFixProviderClass;
        return (QuickFixProvider)this.diagnosticObjectProvider.get(diagnosticClass);
    }

    @ConstructorProperties(value={"diagnosticInfos", "diagnosticObjectProvider"})
    @SuppressFBWarnings(justification="generated code")
    @Generated
    public QuickFixSupplier(Map<String, DiagnosticInfo> diagnosticInfos, DiagnosticObjectProvider diagnosticObjectProvider) {
        this.diagnosticInfos = diagnosticInfos;
        this.diagnosticObjectProvider = diagnosticObjectProvider;
    }
}

