/*
 * Decompiled with CFR 0.152.
 */
package com.github._1c_syntax.bsl.languageserver.codelenses;

import com.github._1c_syntax.bsl.languageserver.codelenses.AbstractMethodComplexityCodeLensSupplier;
import com.github._1c_syntax.bsl.languageserver.codelenses.CodeLensSupplier;
import com.github._1c_syntax.bsl.languageserver.commands.CommandArguments;
import com.github._1c_syntax.bsl.languageserver.commands.complexity.AbstractToggleComplexityInlayHintsCommandSupplier;
import com.github._1c_syntax.bsl.languageserver.commands.complexity.ToggleComplexityInlayHintsCommandArguments;
import com.github._1c_syntax.bsl.languageserver.configuration.Language;
import com.github._1c_syntax.bsl.languageserver.configuration.LanguageServerConfiguration;
import com.github._1c_syntax.bsl.languageserver.context.DocumentContext;
import com.github._1c_syntax.bsl.languageserver.context.symbol.MethodSymbol;
import com.github._1c_syntax.bsl.languageserver.utils.Resources;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.beans.ConstructorProperties;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import lombok.Generated;
import org.eclipse.lsp4j.CodeLens;
import org.eclipse.lsp4j.Command;
import org.eclipse.lsp4j.jsonrpc.messages.Either;

public abstract class AbstractMethodComplexityCodeLensSupplier
implements CodeLensSupplier<ComplexityCodeLensData> {
    private static final String TITLE_KEY = "title";
    private static final int DEFAULT_COMPLEXITY_THRESHOLD = -1;
    protected final LanguageServerConfiguration configuration;
    private final AbstractToggleComplexityInlayHintsCommandSupplier commandSupplier;

    public List<CodeLens> getCodeLenses(DocumentContext documentContext) {
        int complexityThreshold = this.getComplexityThreshold();
        Map methodsComplexity = this.getMethodsComplexity(documentContext);
        return documentContext.getSymbolTree().getMethods().stream().filter(methodSymbol -> (Integer)methodsComplexity.get(methodSymbol) >= complexityThreshold).map(methodSymbol -> this.toCodeLens(methodSymbol, documentContext)).collect(Collectors.toList());
    }

    public CodeLens resolve(DocumentContext documentContext, CodeLens unresolved, ComplexityCodeLensData data) {
        String methodName = data.getMethodName();
        Map methodsComplexity = this.getMethodsComplexity(documentContext);
        documentContext.getSymbolTree().getMethodSymbol(methodName).ifPresent(methodSymbol -> {
            int complexity = (Integer)methodsComplexity.get(methodSymbol);
            String title = Resources.getResourceString((Language)this.configuration.getLanguage(), this.getClass(), (String)TITLE_KEY, (Object[])new Object[]{complexity});
            ToggleComplexityInlayHintsCommandArguments arguments = new ToggleComplexityInlayHintsCommandArguments(this.commandSupplier.getId(), data);
            Command command = this.commandSupplier.createCommand(title, (CommandArguments)arguments);
            unresolved.setCommand(command);
        });
        return unresolved;
    }

    public Class<ComplexityCodeLensData> getCodeLensDataClass() {
        return ComplexityCodeLensData.class;
    }

    protected abstract Map<MethodSymbol, Integer> getMethodsComplexity(DocumentContext var1);

    private int getComplexityThreshold() {
        Either parameters = this.configuration.getCodeLensOptions().getParameters().getOrDefault(this.getId(), Either.forLeft((Object)true));
        if (parameters.isLeft()) {
            return -1;
        }
        return ((Map)parameters.getRight()).getOrDefault("complexityThreshold", -1);
    }

    private CodeLens toCodeLens(MethodSymbol methodSymbol, DocumentContext documentContext) {
        ComplexityCodeLensData data = new ComplexityCodeLensData(documentContext.getUri(), this.getId(), methodSymbol.getName());
        CodeLens codeLens = new CodeLens(methodSymbol.getSubNameRange());
        codeLens.setData((Object)data);
        return codeLens;
    }

    @ConstructorProperties(value={"configuration", "commandSupplier"})
    @SuppressFBWarnings(justification="generated code")
    @Generated
    public AbstractMethodComplexityCodeLensSupplier(LanguageServerConfiguration configuration, AbstractToggleComplexityInlayHintsCommandSupplier commandSupplier) {
        this.configuration = configuration;
        this.commandSupplier = commandSupplier;
    }
}

