/*
 * Decompiled with CFR 0.152.
 */
package com.github._1c_syntax.bsl.languageserver.codelenses;

import com.github._1c_syntax.bsl.languageserver.codelenses.AbstractRunTestsCodeLensSupplier;
import com.github._1c_syntax.bsl.languageserver.codelenses.RunTestCodeLensSupplier;
import com.github._1c_syntax.bsl.languageserver.codelenses.testrunner.TestRunnerAdapter;
import com.github._1c_syntax.bsl.languageserver.configuration.LanguageServerConfiguration;
import com.github._1c_syntax.bsl.languageserver.configuration.codelens.TestRunnerAdapterOptions;
import com.github._1c_syntax.bsl.languageserver.context.DocumentContext;
import com.github._1c_syntax.bsl.languageserver.context.FileType;
import com.github._1c_syntax.bsl.languageserver.context.symbol.MethodSymbol;
import com.github._1c_syntax.bsl.languageserver.context.symbol.SymbolTree;
import com.github._1c_syntax.bsl.languageserver.utils.Resources;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.beans.ConstructorProperties;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Collectors;
import lombok.Generated;
import org.eclipse.lsp4j.CodeLens;
import org.eclipse.lsp4j.Command;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Component;

@Component
public class RunTestCodeLensSupplier
extends AbstractRunTestsCodeLensSupplier<RunTestCodeLensData> {
    @SuppressFBWarnings(justification="generated code")
    @Generated
    private static final Logger LOGGER = LoggerFactory.getLogger(RunTestCodeLensSupplier.class);
    private static final String COMMAND_ID = "language-1c-bsl.languageServer.runTest";
    private final TestRunnerAdapter testRunnerAdapter;
    private final LanguageServerConfiguration configuration;
    private final Resources resources;

    public List<CodeLens> getCodeLenses(DocumentContext documentContext) {
        if (documentContext.getFileType() == FileType.BSL) {
            return Collections.emptyList();
        }
        List testIds = this.testRunnerAdapter.getTestIds(documentContext);
        SymbolTree symbolTree = documentContext.getSymbolTree();
        return testIds.stream().map(arg_0 -> ((SymbolTree)symbolTree).getMethodSymbol(arg_0)).flatMap(Optional::stream).map(methodSymbol -> this.toCodeLens(methodSymbol, documentContext)).collect(Collectors.toList());
    }

    public Class<RunTestCodeLensData> getCodeLensDataClass() {
        return RunTestCodeLensData.class;
    }

    public CodeLens resolve(DocumentContext documentContext, CodeLens unresolved, RunTestCodeLensData data) {
        Path path = Paths.get(documentContext.getUri());
        String testId = data.getTestId();
        TestRunnerAdapterOptions options = this.configuration.getCodeLensOptions().getTestRunnerAdapterOptions();
        String executable = options.getExecutableForCurrentOS();
        Object runText = executable + " " + options.getRunTestArguments();
        runText = String.format((String)runText, path, testId);
        Command command = new Command();
        command.setTitle(this.resources.getResourceString(this.getClass(), "runTest"));
        command.setCommand(COMMAND_ID);
        command.setArguments(List.of(Map.of("text", runText)));
        unresolved.setCommand(command);
        return unresolved;
    }

    private CodeLens toCodeLens(MethodSymbol method, DocumentContext documentContext) {
        String testId = method.getName();
        RunTestCodeLensData codeLensData = new RunTestCodeLensData(documentContext.getUri(), this.getId(), testId);
        CodeLens codeLens = new CodeLens(method.getSubNameRange());
        codeLens.setData((Object)codeLensData);
        return codeLens;
    }

    @ConstructorProperties(value={"testRunnerAdapter", "configuration", "resources"})
    @SuppressFBWarnings(justification="generated code")
    @Generated
    public RunTestCodeLensSupplier(TestRunnerAdapter testRunnerAdapter, LanguageServerConfiguration configuration, Resources resources) {
        this.testRunnerAdapter = testRunnerAdapter;
        this.configuration = configuration;
        this.resources = resources;
    }
}

