/*
 * Decompiled with CFR 0.152.
 */
package com.github._1c_syntax.bsl.languageserver.color;

import com.github._1c_syntax.bsl.languageserver.color.ColorPresentationSupplier;
import com.github._1c_syntax.bsl.languageserver.configuration.Language;
import com.github._1c_syntax.bsl.languageserver.configuration.LanguageServerConfiguration;
import com.github._1c_syntax.bsl.languageserver.context.DocumentContext;
import com.github._1c_syntax.bsl.languageserver.utils.Resources;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.beans.ConstructorProperties;
import java.util.List;
import java.util.Locale;
import lombok.Generated;
import org.eclipse.lsp4j.Color;
import org.eclipse.lsp4j.ColorPresentation;
import org.eclipse.lsp4j.ColorPresentationParams;
import org.eclipse.lsp4j.Range;
import org.eclipse.lsp4j.TextEdit;
import org.springframework.stereotype.Component;

@Component
public class ConstructorColorPresentationSupplier
implements ColorPresentationSupplier {
    private static final String VIA_CONSTRUCTOR_KEY = "viaConstructor";
    private static final String NEW_COLOR_CONSTRUCTOR_KEY = "newColorConstructor";
    private final LanguageServerConfiguration configuration;

    public List<ColorPresentation> getColorPresentation(DocumentContext documentContext, ColorPresentationParams params) {
        Range range = params.getRange();
        Color color = params.getColor();
        int red = (int)(color.getRed() * 255.0);
        int green = (int)(color.getGreen() * 255.0);
        int blue = (int)(color.getBlue() * 255.0);
        Language language = this.configuration.getLanguage();
        Locale scriptLocale = documentContext.getScriptVariantLocale();
        String label = Resources.getResourceString((Language)language, this.getClass(), (String)VIA_CONSTRUCTOR_KEY);
        String newText = Resources.getResourceString((Locale)scriptLocale, this.getClass(), (String)NEW_COLOR_CONSTRUCTOR_KEY, (Object[])new Object[]{red, green, blue});
        TextEdit textEdit = new TextEdit(range, newText);
        return List.of(new ColorPresentation(label, textEdit));
    }

    @ConstructorProperties(value={"configuration"})
    @SuppressFBWarnings(justification="generated code")
    @Generated
    public ConstructorColorPresentationSupplier(LanguageServerConfiguration configuration) {
        this.configuration = configuration;
    }
}

