/*
 * Decompiled with CFR 0.152.
 */
package com.github._1c_syntax.bsl.languageserver.color;

import com.github._1c_syntax.bsl.languageserver.color.ColorPresentationSupplier;
import com.github._1c_syntax.bsl.languageserver.color.WebColor;
import com.github._1c_syntax.bsl.languageserver.configuration.Language;
import com.github._1c_syntax.bsl.languageserver.configuration.LanguageServerConfiguration;
import com.github._1c_syntax.bsl.languageserver.context.DocumentContext;
import com.github._1c_syntax.bsl.languageserver.utils.Resources;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.beans.ConstructorProperties;
import java.util.List;
import java.util.Locale;
import java.util.stream.Collectors;
import lombok.Generated;
import org.eclipse.lsp4j.Color;
import org.eclipse.lsp4j.ColorPresentation;
import org.eclipse.lsp4j.ColorPresentationParams;
import org.eclipse.lsp4j.Range;
import org.eclipse.lsp4j.TextEdit;
import org.springframework.stereotype.Component;

/*
 * Exception performing whole class analysis ignored.
 */
@Component
public class WebColorPresentationSupplier
implements ColorPresentationSupplier {
    private static final String VIA_WEB_COLOR_KEY = "viaWebColors";
    private static final String WEB_COLOR_DOT_KEY = "webColorDot";
    private final LanguageServerConfiguration configuration;

    public List<ColorPresentation> getColorPresentation(DocumentContext documentContext, ColorPresentationParams params) {
        Range range = params.getRange();
        Color color = params.getColor();
        int red = (int)(color.getRed() * 255.0);
        int green = (int)(color.getGreen() * 255.0);
        int blue = (int)(color.getBlue() * 255.0);
        return WebColor.findByColor((int)red, (int)green, (int)blue).map(webColor -> this.toColorPresentation(documentContext, range, webColor)).stream().collect(Collectors.toList());
    }

    private ColorPresentation toColorPresentation(DocumentContext documentContext, Range range, WebColor webColor) {
        Language language = this.configuration.getLanguage();
        Locale scriptLocale = documentContext.getScriptVariantLocale();
        String label = Resources.getResourceString((Language)language, this.getClass(), (String)"viaWebColors");
        String newText = Resources.getResourceString((Locale)scriptLocale, this.getClass(), (String)"webColorDot", (Object[])new Object[]{WebColorPresentationSupplier.webColorName((WebColor)webColor, (Locale)scriptLocale)});
        TextEdit textEdit = new TextEdit(range, newText);
        return new ColorPresentation(label, textEdit);
    }

    private static String webColorName(WebColor webColor, Locale locale) {
        if (locale.equals(Locale.ENGLISH)) {
            return webColor.getEn();
        }
        return webColor.getRu();
    }

    @ConstructorProperties(value={"configuration"})
    @SuppressFBWarnings(justification="generated code")
    @Generated
    public WebColorPresentationSupplier(LanguageServerConfiguration configuration) {
        this.configuration = configuration;
    }
}

