/*
 * Decompiled with CFR 0.152.
 */
package com.github._1c_syntax.bsl.languageserver.context.computer;

import com.github._1c_syntax.bsl.languageserver.aop.MeasuresAspect;
import com.github._1c_syntax.bsl.languageserver.context.DocumentContext;
import com.github._1c_syntax.bsl.languageserver.context.computer.ComplexityData;
import com.github._1c_syntax.bsl.languageserver.context.computer.ComplexitySecondaryLocation;
import com.github._1c_syntax.bsl.languageserver.context.computer.Computer;
import com.github._1c_syntax.bsl.languageserver.context.computer.CyclomaticComplexityComputer;
import com.github._1c_syntax.bsl.languageserver.context.symbol.MethodSymbol;
import com.github._1c_syntax.bsl.languageserver.utils.Ranges;
import com.github._1c_syntax.bsl.languageserver.utils.Trees;
import com.github._1c_syntax.bsl.parser.BSLParser;
import com.github._1c_syntax.bsl.parser.BSLParserBaseListener;
import com.github._1c_syntax.bsl.parser.BSLParserRuleContext;
import com.github._1c_syntax.utils.StringInterner;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import jakarta.annotation.PostConstruct;
import java.beans.ConstructorProperties;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import lombok.Generated;
import org.antlr.v4.runtime.CommonToken;
import org.antlr.v4.runtime.Token;
import org.antlr.v4.runtime.tree.ParseTree;
import org.antlr.v4.runtime.tree.ParseTreeListener;
import org.antlr.v4.runtime.tree.ParseTreeWalker;
import org.antlr.v4.runtime.tree.Tree;
import org.aspectj.lang.JoinPoint;
import org.aspectj.lang.Signature;
import org.aspectj.runtime.reflect.Factory;
import org.eclipse.lsp4j.Range;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.annotation.Scope;
import org.springframework.stereotype.Component;

/*
 * Exception performing whole class analysis ignored.
 */
@Component
@Scope(value="prototype")
public class CyclomaticComplexityComputer
extends BSLParserBaseListener
implements Computer<ComplexityData> {
    private final DocumentContext documentContext;
    private StringInterner stringInterner;
    private int fileComplexity;
    private int fileCodeBlockComplexity;
    private List<ComplexitySecondaryLocation> fileBlockComplexitySecondaryLocations;
    private Map<MethodSymbol, Integer> methodsComplexity;
    private Map<MethodSymbol, List<ComplexitySecondaryLocation>> methodsComplexitySecondaryLocations;
    private MethodSymbol currentMethod;
    private int complexity;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_0;

    @PostConstruct
    public void init() {
        this.fileComplexity = 0;
        this.fileCodeBlockComplexity = 0;
        this.fileBlockComplexitySecondaryLocations = new ArrayList();
        this.resetMethodComplexityCounters();
        this.methodsComplexity = new HashMap();
        this.methodsComplexitySecondaryLocations = new HashMap();
    }

    public ComplexityData compute() {
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_0, (Object)this, (Object)this);
        Object[] objectArray = new Object[]{this, joinPoint};
        AjcClosure1 ajcClosure1 = new AjcClosure1(objectArray);
        return (ComplexityData)MeasuresAspect.aspectOf().measureComputers(ajcClosure1.linkClosureAndJoinPoint(69648));
    }

    public void enterSub(BSLParser.SubContext ctx) {
        Optional methodSymbol = this.documentContext.getSymbolTree().getMethodSymbol((BSLParserRuleContext)ctx);
        if (methodSymbol.isEmpty()) {
            return;
        }
        this.resetMethodComplexityCounters();
        this.currentMethod = (MethodSymbol)methodSymbol.get();
        this.complexityIncrement(this.currentMethod.getSubNameRange());
        super.enterSub(ctx);
    }

    public void exitSub(BSLParser.SubContext ctx) {
        this.incrementFileComplexity();
        if (this.currentMethod != null) {
            this.methodsComplexity.put(this.currentMethod, this.complexity);
        }
        this.currentMethod = null;
        super.exitSub(ctx);
    }

    public void enterFileCodeBlockBeforeSub(BSLParser.FileCodeBlockBeforeSubContext ctx) {
        this.resetMethodComplexityCounters();
        super.enterFileCodeBlockBeforeSub(ctx);
    }

    public void exitFileCodeBlockBeforeSub(BSLParser.FileCodeBlockBeforeSubContext ctx) {
        this.incrementFileComplexity();
        this.incrementFileCodeBlockComplexity();
        super.exitFileCodeBlockBeforeSub(ctx);
    }

    public void enterFileCodeBlock(BSLParser.FileCodeBlockContext ctx) {
        this.resetMethodComplexityCounters();
        super.enterFileCodeBlock(ctx);
    }

    public void exitFileCodeBlock(BSLParser.FileCodeBlockContext ctx) {
        this.incrementFileComplexity();
        this.incrementFileCodeBlockComplexity();
        super.exitFileCodeBlock(ctx);
    }

    public void enterIfBranch(BSLParser.IfBranchContext ctx) {
        this.complexityIncrement(ctx.IF_KEYWORD().getSymbol());
        super.enterIfBranch(ctx);
    }

    public void enterElsifBranch(BSLParser.ElsifBranchContext ctx) {
        this.complexityIncrement(ctx.ELSIF_KEYWORD().getSymbol());
        super.enterElsifBranch(ctx);
    }

    public void enterElseBranch(BSLParser.ElseBranchContext ctx) {
        this.complexityIncrement(ctx.ELSE_KEYWORD().getSymbol());
        super.enterElseBranch(ctx);
    }

    public void enterTernaryOperator(BSLParser.TernaryOperatorContext ctx) {
        this.complexityIncrement(ctx.QUESTION().getSymbol());
        super.enterTernaryOperator(ctx);
    }

    public void enterForEachStatement(BSLParser.ForEachStatementContext ctx) {
        this.complexityIncrement(ctx.FOR_KEYWORD().getSymbol());
        super.enterForEachStatement(ctx);
    }

    public void enterForStatement(BSLParser.ForStatementContext ctx) {
        this.complexityIncrement(ctx.FOR_KEYWORD().getSymbol());
        super.enterForStatement(ctx);
    }

    public void enterWhileStatement(BSLParser.WhileStatementContext ctx) {
        this.complexityIncrement(ctx.WHILE_KEYWORD().getSymbol());
        super.enterWhileStatement(ctx);
    }

    public void enterExceptCodeBlock(BSLParser.ExceptCodeBlockContext ctx) {
        this.complexityIncrement(((BSLParser.TryStatementContext)ctx.getParent()).EXCEPT_KEYWORD().getSymbol());
        super.enterExceptCodeBlock(ctx);
    }

    public void enterGlobalMethodCall(BSLParser.GlobalMethodCallContext ctx) {
        BSLParser.MethodNameContext methodNameContext = ctx.methodName();
        if (methodNameContext != null && this.currentMethod != null) {
            String calledMethodName = methodNameContext.getText();
            if (this.currentMethod.getName().equalsIgnoreCase(calledMethodName)) {
                this.complexityIncrement(methodNameContext.IDENTIFIER().getSymbol());
            }
        }
        super.enterGlobalMethodCall(ctx);
    }

    public void enterGotoStatement(BSLParser.GotoStatementContext ctx) {
        this.complexityIncrement(ctx.GOTO_KEYWORD().getSymbol());
        super.enterGotoStatement(ctx);
    }

    public void enterExpression(BSLParser.ExpressionContext ctx) {
        int emptyTokenType = -1;
        CyclomaticComplexityComputer.flattenExpression((BSLParser.ExpressionContext)ctx).stream().filter(token -> token.getType() != emptyTokenType).forEach(arg_0 -> this.complexityIncrement(arg_0));
        super.enterExpression(ctx);
    }

    private static List<Token> flattenExpression(BSLParser.ExpressionContext ctx) {
        ArrayList<Token> result = new ArrayList<Token>();
        List children = Trees.getChildren((Tree)ctx);
        for (Tree tree : children) {
            if (!(tree instanceof BSLParserRuleContext)) continue;
            BSLParserRuleContext parserRule = (BSLParserRuleContext)tree;
            if (parserRule instanceof BSLParser.MemberContext) {
                CyclomaticComplexityComputer.flattenMember(result, (BSLParser.MemberContext)((BSLParser.MemberContext)parserRule));
                continue;
            }
            if (!(parserRule instanceof BSLParser.OperationContext)) continue;
            CyclomaticComplexityComputer.flattenOperation(result, (BSLParser.OperationContext)((BSLParser.OperationContext)parserRule));
        }
        return result;
    }

    private static void flattenMember(List<Token> result, BSLParser.MemberContext member) {
        BSLParser.ExpressionContext expression = member.expression();
        if (expression == null) {
            return;
        }
        List nestedTokens = CyclomaticComplexityComputer.flattenExpression((BSLParser.ExpressionContext)expression);
        if (nestedTokens.isEmpty()) {
            return;
        }
        BSLParser.UnaryModifierContext unaryModifier = member.unaryModifier();
        if (unaryModifier != null && unaryModifier.NOT_KEYWORD() != null) {
            CommonToken splitter = new CommonToken(-1);
            result.add((Token)splitter);
            result.addAll(nestedTokens);
            result.add((Token)splitter);
        } else {
            result.addAll(nestedTokens);
        }
    }

    private static void flattenOperation(List<Token> result, BSLParser.OperationContext operation) {
        BSLParser.BoolOperationContext boolOperation = operation.boolOperation();
        if (boolOperation != null) {
            result.add(boolOperation.getStart());
        }
    }

    private void resetMethodComplexityCounters() {
        this.complexity = 0;
    }

    private void incrementFileComplexity() {
        this.fileComplexity += this.complexity;
    }

    private void incrementFileCodeBlockComplexity() {
        this.fileCodeBlockComplexity += this.complexity;
    }

    private void complexityIncrement(Token token) {
        this.complexityIncrement(Ranges.create((Token)token));
    }

    private void complexityIncrement(Range range) {
        ++this.complexity;
        this.addSecondaryLocation(range);
    }

    private void addSecondaryLocation(Range range) {
        String message = String.format("+%d", 1);
        ComplexitySecondaryLocation secondaryLocation = new ComplexitySecondaryLocation(range, this.stringInterner.intern(message));
        List locations = this.currentMethod != null ? this.methodsComplexitySecondaryLocations.computeIfAbsent(this.currentMethod, methodSymbol -> new ArrayList()) : this.fileBlockComplexitySecondaryLocations;
        locations.add(secondaryLocation);
    }

    @ConstructorProperties(value={"documentContext"})
    @SuppressFBWarnings(justification="generated code")
    @Generated
    public CyclomaticComplexityComputer(DocumentContext documentContext) {
        this.documentContext = documentContext;
    }

    @Autowired
    @SuppressFBWarnings(justification="generated code")
    @Generated
    void setStringInterner(StringInterner stringInterner) {
        this.stringInterner = stringInterner;
    }

    static {
        CyclomaticComplexityComputer.ajc$preClinit();
    }

    static final /* synthetic */ ComplexityData compute_aroundBody0(CyclomaticComplexityComputer ajc$this, JoinPoint joinPoint) {
        ajc$this.fileComplexity = 0;
        ajc$this.fileCodeBlockComplexity = 0;
        ajc$this.resetMethodComplexityCounters();
        ajc$this.methodsComplexity.clear();
        ParseTreeWalker walker = new ParseTreeWalker();
        walker.walk((ParseTreeListener)ajc$this, (ParseTree)ajc$this.documentContext.getAst());
        return new ComplexityData(ajc$this.fileComplexity, ajc$this.fileCodeBlockComplexity, ajc$this.fileBlockComplexitySecondaryLocations, ajc$this.methodsComplexity, ajc$this.methodsComplexitySecondaryLocations);
    }

    private static /* synthetic */ void ajc$preClinit() {
        Factory factory = new Factory("CyclomaticComplexityComputer.java", CyclomaticComplexityComputer.class);
        ajc$tjp_0 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "compute", "com.github._1c_syntax.bsl.languageserver.context.computer.CyclomaticComplexityComputer", "", "", "", "com.github._1c_syntax.bsl.languageserver.context.computer.ComplexityData"), 88);
    }
}

